% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_unique_values.R
\name{detect_unique_values}
\alias{detect_unique_values}
\title{Search for unique values / distinct combinations}
\usage{
detect_unique_values(activitylog, column_labels, filter_condition = NULL)
}
\arguments{
\item{activitylog}{The activity log}

\item{column_labels}{The names of columns in the activity log for which you want to show the different combinations found in the log. If only one column is provided, this results in a list of unique values in that column.}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
activitylog containing the unique (distinct) values (combinations) in the indicated column(s)
}
\description{
Function that lists all distinct combinations of the given columns in the activity log
}
\examples{
\donttest{
data("hospital_actlog")
detect_unique_values(activitylog = hospital_actlog,
     column_labels = "activity")
detect_unique_values(activitylog = hospital_actlog,
     column_labels = c("activity", "originator"))
}
}
