% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyl_vonmises.R
\name{cyl_vonmises}
\alias{cyl_vonmises}
\title{Construction of '\code{cyl_vonmises}' Objects}
\usage{
cyl_vonmises(mu = 0, kappa = 1, flip = FALSE)
}
\arguments{
\item{mu}{\link[base]{numeric} value giving the mean of the von Mises
function used to construct the copula.}

\item{kappa}{\link[base]{numeric} value giving the concentration of the
von Mises function used to construct the copula.}

\item{flip}{\link[base]{logical} value indicating whether the copula
should be rotated 90 degrees to capture negative correlation.}
}
\value{
An \R object of class '\code{\linkS4class{cyl_vonmises}}'.
}
\description{
Constructs a circular-linear von Mises copula according to
\insertCite{Johnson1978;textual}{cylcop} of class
 '\code{\linkS4class{cyl_vonmises}}'.
}
\examples{
cop <- cyl_vonmises(mu=pi, kappa=10, flip = TRUE)
if(interactive()){
 plot_cop_surf(copula = cop, type = "pdf", plot_type = "ggplot", resolution = 20)
}

cop <- cyl_vonmises(mu=0, kappa=8, flip = FALSE)
if(interactive()){
 plot_cop_surf(copula = cop, type = "pdf", plot_type = "ggplot", resolution = 20)
}

}
\references{
\insertRef{Johnson1978}{cylcop}

\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
