% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vital_rate.R
\name{vital_rate}
\alias{vital_rate}
\title{Vital rate calculation}
\usage{
vital_rate(vr, sp, site, param, env = NULL, densities)
}
\arguments{
\item{vr}{integer or char, vital rate to obtain, from the ones defined in `param`.
So far, valid names are "Sj","Sn","Sr","Rn","Rr","D","Ds,"O".}

\item{sp}{integer or char, species}

\item{site}{intger or char, site}

\item{param}{param nested list (see `build_param`)}

\item{env}{optional numeric, environmental forcing}

\item{densities}{densities of all sp in the site, including individuals from
all three life stages}
}
\value{
numeric value
}
\description{
Calculates vital rates from their effect sizes and terms. This
is equivalent to predicting from a binomial glm with
given coefficients.
In this version, the user needs to ensure that `param` and `env` match,
i.e. that if the `param` list is defined with environmental forcing, it is
passed here, and viceversa. In future versions I may implement checks for that
here, but for now, be aware that it will fail.
}
