% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum_control.R
\name{cusum_control}
\alias{cusum_control}
\title{cusum_control}
\usage{
cusum_control(
  x,
  target = NULL,
  std_dev = NULL,
  desired_shift = 1,
  k = 0.5,
  h = 4
)
}
\arguments{
\item{x}{input vector}

\item{target}{target value for comparison, the mean of x will be used if missing}

\item{std_dev}{Defaults to the screened moving range of x.
A known or desired value for standard deviation can be supplied instead.}

\item{desired_shift}{how many standard deviations do you want to detect?
This value is typically between  0.5 to 1. Defaults to 1.}

\item{k}{allowable slack - defaults to half the standard deviation multiplied by desired shift}

\item{h}{action limits -  usually between 4 and 5, defaults to 4.
The standard deviation is multiplied by this value to determine the upper and lower limits on the chart}
}
\value{
data.frame showing original inputs and calculated control limits
}
\description{
cusum_control
}
\examples{
test_vec3 <- c(1,1,2,3,5,7,11,7,5,7,8,9,5)
controls <- cusum_control(test_vec3, target = 4)


}
