% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7-Path.R
\name{path_arc}
\alias{path_arc}
\title{Arc Path}
\usage{
path_arc(yx, start, end, r = 1, n = 50)
}
\arguments{
\item{yx}{center \code{(row, col)} coordinate of circle}

\item{start}{starting angle in radians}

\item{end}{ending angle in radians}

\item{r}{radius of circle}

\item{n}{number of points along curve to calculate}
}
\value{
Nx2 matrix of \code{(row, column)} coordinates
}
\description{
Calculate the path of an arc within a grid.
}
\examples{
path_arc(yx=c(10,10), start=pi/2, end=pi, r=6)

}
\seealso{
Other path-fitting functions: 
\code{\link{path_bezier}()},
\code{\link{path_circle}()},
\code{\link{path_ellipse}()},
\code{\link{path_fill}()},
\code{\link{path_fn}()},
\code{\link{path_intersection}()},
\code{\link{path_lerp}()},
\code{\link{path_ray}()},
\code{\link{path_rect}()},
\code{\link{path_shape}()}
}
\concept{path-fitting functions}
