% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D2Bsplines.R
\name{D2Bsplines}
\alias{D2Bsplines}
\title{Computation of the 2nd derivative of a cubic B-spline basis associated to a given vector of knots}
\usage{
D2Bsplines(x, knots)
}
\arguments{
\item{x}{vector of values where the 2nd derivative of the B-spline basis must be evaluated.}

\item{knots}{vector of knots spanning the desired B-spline basis.}
}
\value{
A matrix of dimension \code{length(x)} by \code{(length(knots)+2)}.

Each column of the matrix corresponds to (the 2nd derivative of) one cubic B-spline in the basis.
}
\description{
Computation of the 2nd derivative of a cubic B-spline basis associated to a given vector of knots
}
\examples{
D2Bsplines(x=runif(20),knots=seq(0,1,length=11))
}
