% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.haz.R
\name{general.haz}
\alias{general.haz}
\title{Extract general population hazard}
\usage{
general.haz(
  time,
  rmap,
  data = NULL,
  ratetable = cuRe::survexp.dk,
  scale = 365.24
)
}
\arguments{
\item{time}{Either a numeric vector of follow-up times (in days) or a character indicating the variable
containing the follow-up times in the data.}

\item{rmap}{A named list. The names must match the dimension names of the ratetable input.
The elements should be given as vectors containing the relevant variables in the data
or a character indicating the name of the variable in the data.
Elements in the list named 'age' and 'year' are transformed such that the age and year of
the event/censoring time is used.
'age' must be a numeric vector given as age in days
or a character indicating the variable containing the patient ages in the data.
'year' must be of class \code{Date} with the calendar time points
or a character indicating the variable containing the calendar times in the data.
Other variables should be coded as characters in the data.}

\item{data}{The data from which to extract variables from.
If \code{time}, \code{age}, \code{sex}, or \code{year} are not characters, this will not be used.}

\item{ratetable}{Object of class \code{ratetable} to extract background hazards from. Defaults to \code{survexp.dk}.}

\item{scale}{Numeric to adjust the scale of the outputted hazard values.
If the ratetable provides daily hazards and \code{scale = 365.24} (default), the outputted hazard values are yearly.}
}
\value{
An object of class \code{numeric} containing the yearly expected hazards.
}
\description{
Yearly general population hazards matched on age, gender, and calendar year is extracted from a ratetable.
}
\examples{
##Use data cleaned version of the colon cancer data from the rstpm2 package
data("colonDC")
set.seed(2)
colonDC <- colonDC[sample(1:nrow(colonDC), 1000), ]

##Extract general population hazards
bhaz1 <- general.haz(time = "FU",
                     rmap = list(age = "agedays", sex = "sex", year= "dx"),
                     data = colonDC,
                     ratetable = survexp.dk)

bhaz2 <- general.haz(time = colonDC$FU,
                     rmap = list(age = colonDC$agedays, sex = colonDC$sex, year = colonDC$dx),
                     data = colonDC,
                     ratetable = survexp.dk)

all(bhaz2 == bhaz1)
}
