% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.r
\name{simclbin}
\alias{simclbin}
\title{Simulation of Independent Bernoulli Observations}
\usage{
simclbin(nser = 100, nsim = 1e+05, probs = c(0.5, 0.6, 0.7, 0.8, 0.9))
}
\arguments{
\item{nser}{length of sequence simulated}

\item{nsim}{number of simulations}

\item{probs}{binomial probabilites}
}
\value{
a data frame with the number of crossings and
longest run for each probability. For instance
the variables nc0.5 and lr0.5 are the number of
crossings and the longest run for success probability
0.5. One row for each simulation.
}
\description{
Simulation of a sequence of independent Bernoulli
Observations. To reduce the amount of random draws, each
simulation is based on a sequence of standard normal
variables, and whether each observation is above a shift
defined by the binomial probabilities assumed.
}
\examples{
cl30simbin <- simclbin(nser=30, nsim=100)
mean(cl30simbin$nc0.5) # mean number of crossings, p=0.5
mean(cl30simbin$lr0.9) # mean longest run, p=0.9
}
