% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossrunchange.r
\name{crossrunchange}
\alias{crossrunchange}
\title{Joint Distribution for Crossings and Runs, Varying Success Probability.}
\usage{
crossrunchange(
  nmax = 100,
  prob = rep(0.5, 100),
  mult = 2,
  prec = 120,
  printn = FALSE
)
}
\arguments{
\item{nmax}{max sequence length.}

\item{prob}{success probabilities.}

\item{mult}{multiplier for joint probabilities.}

\item{prec}{mpft precision.}

\item{printn}{logical for progress output.}
}
\value{
list pt of joint probabilities. Cumulative probabilities
qt within each row are also included. Further, mostly for code
checking, lists pat and qat conditional on starting with a success,
and pbt and qbt conditional of starting with a failure, are
included.
}
\description{
Joint probability distribution for the number of crossings
C and the longest run L in a sequence of n independent Bernoulli observations
with p ossibly varying success probability. To enhance precision, results are stored
in mpfr arrays and the probabilities are multiplied by \eqn{m^{n-1}}
for a multiplier m.
}
\examples{
prob10 <- c(rep(.5,5),rep(.7,5))
crchange10 <- crossrunchange(nmax=10, prob=prob10,printn=TRUE)
print(crchange10$pt[[10]])
}
