% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_activity.R
\name{sch_add_activities}
\alias{sch_add_activities}
\title{Add Activities}
\usage{
sch_add_activities(sch, id, name, duration, ...)
}
\arguments{
\item{sch}{A schedule object.}

\item{id}{Activity id that will be used to make
relation between activities. It must be unique.}

\item{name}{The name of activity.}

\item{duration}{A number that represents the activity's duration.
It must be equal or greater than zero.}

\item{...}{One or more vectors for associated activity attributes.}
}
\value{
A schedule with a activity tibble (atb) added.
}
\description{
Combine several vectors for activities and their attributes into a tibble,
which can be combined with other similarly-generated tibbles, resulting
in unique tibble to be added in a schedule. If the schedule already
contain some activities, the new activities will be added in the end.
}
\details{
A activity tibble, or atb, has at least the following columns:
\itemize{
\item \code{id} (of type \code{integer}): Activity id.
It is an integer number that must be unique within a schedule.
\item \code{name} (of type \code{character}): Activity name. It may be empty string.
\item \code{duration} (of type \code{integer}): Activity duration.
It is integer number without unit time. It may be zero.
}

An arbitrary number of additional columns containing data attributes
can be part of the atb, so long as they follow the aforementioned columns.
}
\examples{
# Example #1
sch <- sch_new() \%>\%
  sch_add_activities(
    id        = 1:17,
    name      = paste("a", as.character(1:17), sep=""),
    duration  = c(1L,2L,2L,4L,3L,3L,3L,2L,1L,1L,2L,1L,1L,1L,1L,2L,1L)
  ) \%>\%
  sch_plan()
sch_duration(sch)
sch_activities(sch)

# Example #2
sch <- sch_new() \%>\%
  sch_add_activities(
    id        = 1:17,
    name      = paste("a", as.character(1:17), sep=""),
    duration  = c(1L,2L,2L,4L,3L,3L,3L,2L,1L,1L,2L,1L,1L,1L,1L,2L,1L),
    resource  = "Rubens",
    cost      = 123.45
  ) \%>\%
  sch_plan()
sch_duration(sch)
atb <- sch_activities(sch)
atb$resource
atb$cost

# Example #3
sch <- sch_new() \%>\%
  sch_add_activities(
    id        = 1:17,
    name      = paste("a", as.character(1:17), sep=""),
    duration  = c(1L,2L,2L,4L,3L,3L,3L,2L,1L,1L,2L,1L,1L,1L,1L,2L,1L),
    resource  = c(
      "Rubens", "Jose", "Rosa", "Rodrigues", "Silva",
      "Rubens", "Jose", "Rosa", "Rodrigues", "Silva",
      "Rubens", "Jose", "Rosa", "Rodrigues", "Silva",
      "Rubens", "Jose"),
    cost      = c(
      123.45, 234.56, 345.56, 456.78, 567.89,
      123.45, 234.56, 345.56, 456.78, 567.89,
      123.45, 234.56, 345.56, 456.78, 567.89,
      123.45, 234.56)
  ) \%>\%
  sch_plan()
sch_duration(sch)
atb <- sch_activities(sch)
atb$resource
atb$cost

}
\seealso{
\code{\link[=sch_reference]{sch_reference()}}, \code{\link[=sch_add_relations]{sch_add_relations()}}, \code{\link[=sch_add_activity]{sch_add_activity()}},
\code{\link[=sch_title]{sch_title()}}, \code{\link[=sch_nr_activities]{sch_nr_activities()}}, \code{\link[=sch_new]{sch_new()}}, \code{\link[=sch_plan]{sch_plan()}},
\code{\link[=sch_get_activity]{sch_get_activity()}}, \code{\link[=sch_has_any_activity]{sch_has_any_activity()}},
\code{\link[=sch_change_activities_duration]{sch_change_activities_duration()}}.
}
