% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Suicide_Germany_df}
\alias{Suicide_Germany_df}
\title{Suicide Rates in Germany}
\format{
A data frame with 306 observations and 6 variables:
\describe{
  \item{Freq}{Numeric variable representing the frequency of suicides.}
  \item{sex}{Factor indicating the sex of the individual (2 levels: 'Male', 'Female').}
  \item{method}{Factor indicating the method of suicide (9 levels).}
  \item{age}{Numeric variable representing the age of the individual.}
  \item{age.group}{Factor indicating the age group (5 levels).}
  \item{method2}{Factor indicating a secondary categorization of the suicide method (8 levels).}
}
}
\source{
Heuer, 1979. Suicide Rates in West Germany.
}
\usage{
data(Suicide_Germany_df)
}
\description{
This dataset contains information on suicide rates in West Germany, classified by age, sex, and method of suicide.
The data was collected from Heuer (1979) and provides detailed insight into suicide rates across different demographic groups.
It includes the frequency of suicides, categorized by sex, method of suicide, and age group.
}
\details{
The dataset name has been changed to 'Suicide_Germany_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix 'df'
indicates that the dataset is a data frame. The original content has not been modified in any way.
}
