% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependence_tree.R
\name{build_dependence_tree.cranly_network}
\alias{build_dependence_tree.cranly_network}
\alias{cranly_dependence_tree}
\title{Construct a \code{\link{cranly_dependence_tree}} object}
\usage{
\method{build_dependence_tree}{cranly_network}(
  x,
  package = Inf,
  base = FALSE,
  recommended = TRUE,
  global = TRUE,
  ...
)
}
\arguments{
\item{x}{a  \code{\link{cranly_network}} object.}

\item{package}{a vector of character strings with the package names to be matched. Default is \code{\link{Inf}} which returns all available packages in \code{x} for further subsetting.}

\item{base}{logical. Should we include base packages in the subset? Default is \code{TRUE}.}

\item{recommended}{logical. Should we include recommended packages in the subset? Default is \code{TRUE}.}

\item{global}{logical. If \code{TRUE} (default) the network summary statistics are computed on \code{object}, otherwise, on the subset of \code{object} according to \code{package}, \code{author}, \code{directive}, \code{base}, \code{recommended}.}

\item{...}{currently not used.}
}
\description{
Construct a \code{\link{cranly_dependence_tree}} object
}
\examples{
\donttest{
cran_db <- clean_CRAN_db()
package_network <- build_network(cran_db)
dep_tree <- build_dependence_tree(package_network, package = "PlackettLuce")
plot(dep_tree)
}

}
\seealso{
\code{\link[=compute_dependence_tree]{compute_dependence_tree()}} \code{\link[=plot.cranly_dependence_tree]{plot.cranly_dependence_tree()}} \code{\link[=summary.cranly_dependence_tree]{summary.cranly_dependence_tree()}}
}
