% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stock_and_yogo.R
\name{stock_yogo_reccomender}
\alias{stock_yogo_reccomender}
\title{Recommend a critical value for the Cragg-Donald test given a maximum allowable bias/size distortion}
\usage{
stock_yogo_reccomender(K, N, B, size_bias)
}
\arguments{
\item{K}{(int). The number of instruments.}

\item{N}{(int).  The number of endogenous variables (treatments)}

\item{B}{One of [.05, .1, .15, .2, .25, .3]. The maximum size of allowable bias relative
to the normal OLS or the maximum Wald test size distortion.}

\item{size_bias}{Either "bias" or "size". Whether to use a critical
value based on the maximum allowable bias relative to regular OLS (bias), or maximum
Wald test size distortion.}
}
\value{
(float) the recommended critical value.
}
\description{
Recommend a critical value for the Cragg-Donald test given a maximum allowable bias/size distortion
}
\examples{
#To reccomend a critical value for a test with 2 endogenous variables
#and four instruments based on a 5\% maximum allowable bias relative to OLS

stock_yogo_reccomender(4,2,.05,"bias")

}
