skip_on_os("mac")
# map
testthat::test_that("map try_emplace integer integer", {
  v <- cpp_map(4:9, 12:17)
  testthat::expect_invisible(try_emplace(v, 12L, 14L))
  testthat::expect_equal(to_r(v), data.frame(key = c(4:9, 14L), value = c(12:17, 12L)))
  testthat::expect_error(try_emplace(v, 13:14L, 10:11))
})
testthat::test_that("map try_emplace integer double", {
  v <- cpp_map(4:9, seq.int(1, 3.5, 0.5))
  testthat::expect_invisible(try_emplace(v, 12, 14L))
  testthat::expect_equal(to_r(v), data.frame(key = c(4:9, 14L), value = c(seq.int(1, 3.5, 0.5), 12)))
  testthat::expect_error(try_emplace(v, c(13, 14), 10:11))
})
testthat::test_that("map try_emplace integer string", {
  v <- cpp_map(4:9, c("Once", "upon", "a", "time", "in", "R"))
  testthat::expect_invisible(try_emplace(v, "world", 14L))
  testthat::expect_equal(to_r(v), data.frame(key = c(4:9, 14L), value = c("Once", "upon", "a", "time", "in", "R", "world")))
  testthat::expect_error(try_emplace(v, c("hello", "world"), 10:11))
})
testthat::test_that("map try_emplace integer boolean", {
  v <- cpp_map(4:9, c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE))
  testthat::expect_invisible(try_emplace(v, TRUE, 14L))
  testthat::expect_equal(to_r(v), data.frame(key = c(4:9, 14L), value = c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE)))
  testthat::expect_error(try_emplace(v, c(TRUE, FALSE), 10:11))
})
testthat::test_that("map try_emplace double integer", {
  v <- cpp_map(seq.int(2, 4.5, 0.5), 12:17)
  testthat::expect_invisible(try_emplace(v, 12L, 5))
  testthat::expect_equal(to_r(v), data.frame(key = c(seq.int(2, 4.5, 0.5), 5), value = c(12:17, 12L)))
  testthat::expect_error(try_emplace(v, 13:14L, c(10, 11)))
})
testthat::test_that("map try_emplace double double", {
  v <- cpp_map(seq.int(2, 4.5, 0.5), seq.int(1, 3.5, 0.5))
  testthat::expect_invisible(try_emplace(v, 12, 5))
  testthat::expect_equal(to_r(v), data.frame(key = c(seq.int(2, 4.5, 0.5), 5), value = c(seq.int(1, 3.5, 0.5), 12)))
  testthat::expect_error(try_emplace(v, c(13, 14), c(10, 11)))
})
testthat::test_that("map try_emplace double string", {
  v <- cpp_map(seq.int(2, 4.5, 0.5), c("Once", "upon", "a", "time", "in", "R"))
  testthat::expect_invisible(try_emplace(v, "world", 14))
  testthat::expect_equal(to_r(v), data.frame(key = c(seq.int(2, 4.5, 0.5), 14), value = c("Once", "upon", "a", "time", "in", "R", "world")))
  testthat::expect_error(try_emplace(v, c("hello", "world"), c(10, 11)))
})
testthat::test_that("map try_emplace double boolean", {
  v <- cpp_map(seq.int(2, 4.5, 0.5), c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE))
  testthat::expect_invisible(try_emplace(v, TRUE, 14))
  testthat::expect_equal(to_r(v), data.frame(key = c(seq.int(2, 4.5, 0.5), 14), value = c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE)))
  testthat::expect_error(try_emplace(v, c(TRUE, FALSE), c(10, 11)))
})
testthat::test_that("map try_emplace string integer", {
  v <- cpp_map(c("A", "quick", "test", "of", "the", "package"), 12:17)
  testthat::expect_invisible(try_emplace(v, 12L, "world"))
  testthat::expect_equal(to_r(v), data.frame(key = c("A", "of", "package", "quick", "test", "the", "world"), value = c(12L, 15L, 17L, 13L, 14L, 16L, 12L)))
  testthat::expect_error(try_emplace(v, 13:14L, c("hello", "there")))
})
testthat::test_that("map try_emplace string double", {
  v <- cpp_map(c("A", "quick", "test", "of", "the", "package"), seq.int(1, 3.5, 0.5))
  testthat::expect_invisible(try_emplace(v, 12, "world"))
  testthat::expect_equal(to_r(v), data.frame(key = c("A", "of", "package", "quick", "test", "the", "world"), value = c(1, 2.5, 3.5, 1.5, 2, 3, 12)))
  testthat::expect_error(try_emplace(v, c(13, 14), c("hello", "there")))
})
testthat::test_that("map try_emplace string string", {
  v <- cpp_map(c("A", "quick", "test", "of", "the", "package"), c("Once", "upon", "a", "time", "in", "R"))
  testthat::expect_invisible(try_emplace(v, "there", "world"))
  testthat::expect_equal(to_r(v), data.frame(key = c("A", "of", "package", "quick", "test", "the", "world"), value = c("Once", "time", "R", "upon", "a",
    "in", "there")))
  testthat::expect_error(try_emplace(v, c("a", "test"), c("hello", "there")))
})
testthat::test_that("map try_emplace string boolean", {
  v <- cpp_map(c("A", "quick", "test", "of", "the", "package"), c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE))
  testthat::expect_invisible(try_emplace(v, FALSE, "world"))
  testthat::expect_equal(to_r(v), data.frame(key = c("A", "of", "package", "quick", "test", "the", "world"), value = c(TRUE, TRUE, FALSE, FALSE, TRUE,
    FALSE, FALSE)))
  testthat::expect_error(try_emplace(v, c(TRUE, FALSE), c("hello", "there")))
})
testthat::test_that("map try_emplace boolean integer", {
  v <- cpp_map(TRUE, 12L)
  testthat::expect_invisible(try_emplace(v, 2L, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = c(2L, 12L)))
  testthat::expect_error(try_emplace(v, 3:4, c(TRUE, FALSE)))
})
testthat::test_that("map try_emplace boolean double", {
  v <- cpp_map(TRUE, 1.5)
  testthat::expect_invisible(try_emplace(v, 2, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = c(2, 1.5)))
  testthat::expect_error(try_emplace(v, c(3, 4), c(TRUE, FALSE)))
})
testthat::test_that("map try_emplace boolean string", {
  v <- cpp_map(TRUE, "upon")
  testthat::expect_invisible(try_emplace(v, "world", FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = c("world", "upon")))
  testthat::expect_error(try_emplace(v, c("hello", "there"), c(TRUE, FALSE)))
})
testthat::test_that("map try_emplace boolean boolean", {
  v <- cpp_map(TRUE, FALSE)
  testthat::expect_invisible(try_emplace(v, TRUE, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = c(TRUE, FALSE)))
  testthat::expect_error(try_emplace(v, c(TRUE, FALSE), c(TRUE, FALSE)))
})

# unordered_map
testthat::test_that("unordered_map try_emplace integer integer", {
  v <- cpp_unordered_map(4:9, 12:17)
  testthat::expect_invisible(try_emplace(v, 12L, 14L))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(4:9, 14L), value = c(12:17, 12L)))
  testthat::expect_error(try_emplace(v, 13:14L, 10:11))
})
testthat::test_that("unordered_map try_emplace integer double", {
  v <- cpp_unordered_map(4:9, seq.int(1, 3.5, 0.5))
  testthat::expect_invisible(try_emplace(v, 12, 14L))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(4:9, 14L), value = c(seq.int(1, 3.5, 0.5), 12)))
  testthat::expect_error(try_emplace(v, c(13, 14), 10:11))
})
testthat::test_that("unordered_map try_emplace integer string", {
  v <- cpp_unordered_map(4:9, c("Once", "upon", "a", "time", "in", "R"))
  testthat::expect_invisible(try_emplace(v, "world", 14L))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(4:9, 14L), value = c("Once", "upon", "a", "time", "in", "R", "world")))
  testthat::expect_error(try_emplace(v, c("hello", "world"), 10:11))
})
testthat::test_that("unordered_map try_emplace integer boolean", {
  v <- cpp_unordered_map(4:9, c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE))
  testthat::expect_invisible(try_emplace(v, TRUE, 14L))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(4:9, 14L), value = c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE)))
  testthat::expect_error(try_emplace(v, c(TRUE, FALSE), 10:11))
})
testthat::test_that("unordered_map try_emplace double integer", {
  v <- cpp_unordered_map(seq.int(2, 4.5, 0.5), 12:17)
  testthat::expect_invisible(try_emplace(v, 12L, 5))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(seq.int(2, 4.5, 0.5), 5), value = c(12:17, 12L)))
  testthat::expect_error(try_emplace(v, 13:14L, c(10, 11)))
})
testthat::test_that("unordered_map try_emplace double double", {
  v <- cpp_unordered_map(seq.int(2, 4.5, 0.5), seq.int(1, 3.5, 0.5))
  testthat::expect_invisible(try_emplace(v, 12, 5))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(seq.int(2, 4.5, 0.5), 5), value = c(seq.int(1, 3.5, 0.5), 12)))
  testthat::expect_error(try_emplace(v, c(13, 14), c(10, 11)))
})
testthat::test_that("unordered_map try_emplace double string", {
  v <- cpp_unordered_map(seq.int(2, 4.5, 0.5), c("Once", "upon", "a", "time", "in", "R"))
  testthat::expect_invisible(try_emplace(v, "world", 14))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(seq.int(2, 4.5, 0.5), 14), value = c("Once", "upon", "a", "time", "in", "R", "world")))
  testthat::expect_error(try_emplace(v, c("hello", "world"), c(10, 11)))
})
testthat::test_that("unordered_map try_emplace double boolean", {
  v <- cpp_unordered_map(seq.int(2, 4.5, 0.5), c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE))
  testthat::expect_invisible(try_emplace(v, TRUE, 14))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(seq.int(2, 4.5, 0.5), 14), value = c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE)))
  testthat::expect_error(try_emplace(v, c(TRUE, FALSE), c(10, 11)))
})
testthat::test_that("unordered_map try_emplace string integer", {
  v <- cpp_unordered_map(c("A", "quick", "test", "of", "the", "package"), 12:17)
  testthat::expect_invisible(try_emplace(v, 12L, "world"))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c("A", "of", "package", "quick", "test", "the", "world"), value = c(12L, 15L, 17L, 13L,
    14L, 16L, 12L)))
  testthat::expect_error(try_emplace(v, 13:14L, c("hello", "there")))
})
testthat::test_that("unordered_map try_emplace string double", {
  v <- cpp_unordered_map(c("A", "quick", "test", "of", "the", "package"), seq.int(1, 3.5, 0.5))
  testthat::expect_invisible(try_emplace(v, 12, "world"))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c("A", "of", "package", "quick", "test", "the", "world"), value = c(1, 2.5, 3.5, 1.5, 2,
    3, 12)))
  testthat::expect_error(try_emplace(v, c(13, 14), c("hello", "there")))
})
testthat::test_that("unordered_map try_emplace string string", {
  v <- cpp_unordered_map(c("A", "quick", "test", "of", "the", "package"), c("Once", "upon", "a", "time", "in", "R"))
  testthat::expect_invisible(try_emplace(v, "there", "world"))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c("A", "of", "package", "quick", "test", "the", "world"), value = c("Once", "time", "R",
    "upon", "a", "in", "there")))
  testthat::expect_error(try_emplace(v, c("a", "test"), c("hello", "there")))
})
testthat::test_that("unordered_map try_emplace string boolean", {
  v <- cpp_unordered_map(c("A", "quick", "test", "of", "the", "package"), c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE))
  testthat::expect_invisible(try_emplace(v, FALSE, "world"))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c("A", "of", "package", "quick", "test", "the", "world"), value = c(TRUE, TRUE, FALSE,
    FALSE, TRUE, FALSE, FALSE)))
  testthat::expect_error(try_emplace(v, c(TRUE, FALSE), c("hello", "there")))
})
testthat::test_that("unordered_map try_emplace boolean integer", {
  v <- cpp_unordered_map(TRUE, 12L)
  testthat::expect_invisible(try_emplace(v, 2L, FALSE))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(FALSE, TRUE), value = c(2L, 12L)))
  testthat::expect_error(try_emplace(v, 3:4, c(TRUE, FALSE)))
})
testthat::test_that("unordered_map try_emplace boolean double", {
  v <- cpp_unordered_map(TRUE, 1.5)
  testthat::expect_invisible(try_emplace(v, 2, FALSE))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(FALSE, TRUE), value = c(2, 1.5)))
  testthat::expect_error(try_emplace(v, c(3, 4), c(TRUE, FALSE)))
})
testthat::test_that("unordered_map try_emplace boolean string", {
  v <- cpp_unordered_map(TRUE, "upon")
  testthat::expect_invisible(try_emplace(v, "world", FALSE))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(FALSE, TRUE), value = c("world", "upon")))
  testthat::expect_error(try_emplace(v, c("hello", "there"), c(TRUE, FALSE)))
})
testthat::test_that("unordered_map try_emplace boolean boolean", {
  v <- cpp_unordered_map(TRUE, FALSE)
  testthat::expect_invisible(try_emplace(v, TRUE, FALSE))
  r <- testthat::expect_no_error(to_r(v))
  testthat::expect_equal(as.list(r[order(r$key),]), list(key = c(FALSE, TRUE), value = c(TRUE, FALSE)))
  testthat::expect_error(try_emplace(v, c(TRUE, FALSE), c(TRUE, FALSE)))
})
