skip_on_os("mac")
# set
testthat::test_that("set to_r integer", {
  v <- cpp_set(4:6)
  testthat::expect_equal(to_r(v), 4:6)
  testthat::expect_equal(to_r(v, n = 2), 4:5)
  testthat::expect_equal(to_r(v, n = -2), 6:5)
  testthat::expect_equal(to_r(v, from = 6), 6L)
  testthat::expect_equal(to_r(v, to = 4), 4L)
  testthat::expect_equal(to_r(v, from = 6, to = 6), 6L)
})
testthat::test_that("set to_r double", {
  v <- cpp_set(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v, n = 2), seq.int(1, 1.5, 0.5))
  testthat::expect_equal(to_r(v, n = -2), seq.int(2, 1.5, -0.5))
  testthat::expect_equal(to_r(v, from = 2), 2)
  testthat::expect_equal(to_r(v, to = 1), 1)
  testthat::expect_equal(to_r(v, from = 2, to = 2), 2)
})
testthat::test_that("set to_r string", {
  v <- cpp_set(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v, n = 2), c("hello", "there"))
  testthat::expect_equal(to_r(v, n = -2), c("world", "there"))
  testthat::expect_equal(to_r(v, from = "world"), "world")
  testthat::expect_equal(to_r(v, to = "hello"), "hello")
  testthat::expect_equal(to_r(v, from = "world", to = "world"), "world")
})
testthat::test_that("set to_r boolean", {
  v <- cpp_set(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), c(FALSE, TRUE))
  testthat::expect_equal(to_r(v, n = 1), FALSE)
  testthat::expect_equal(to_r(v, n = -1), TRUE)
  testthat::expect_equal(to_r(v, from = TRUE), TRUE)
  testthat::expect_equal(to_r(v, to = FALSE), FALSE)
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), TRUE)
})

# unordered_set
testthat::test_that("unordered_set to_r integer", {
  v <- cpp_unordered_set(4:6)
  testthat::expect_setequal(to_r(v), 4:6)
  testthat::expect_length(to_r(v, n = 2), 2L)
})
testthat::test_that("unordered_set to_r double", {
  v <- cpp_unordered_set(seq.int(1, 2, 0.5))
  testthat::expect_setequal(to_r(v), seq.int(1, 2, 0.5))
  testthat::expect_length(to_r(v, n = 2), 2L)
})
testthat::test_that("unordered_set to_r string", {
  v <- cpp_unordered_set(c("hello", "there", "world"))
  testthat::expect_setequal(to_r(v), c("hello", "there", "world"))
  testthat::expect_length(to_r(v, n = 2), 2L)
})
testthat::test_that("unordered_set to_r boolean", {
  v <- cpp_unordered_set(c(TRUE, FALSE))
  testthat::expect_setequal(to_r(v), c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 1), 1L)
})

# multiset
testthat::test_that("multiset to_r integer", {
  v <- cpp_multiset(4:6)
  testthat::expect_equal(to_r(v), 4:6)
  testthat::expect_equal(to_r(v, n = 2), 4:5)
  testthat::expect_equal(to_r(v, n = -2), 6:5)
  testthat::expect_equal(to_r(v, from = 6), 6L)
  testthat::expect_equal(to_r(v, to = 4), 4L)
  testthat::expect_equal(to_r(v, from = 6, to = 6), 6L)
})
testthat::test_that("multiset to_r double", {
  v <- cpp_multiset(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v, n = 2), seq.int(1, 1.5, 0.5))
  testthat::expect_equal(to_r(v, n = -2), seq.int(2, 1.5, -0.5))
  testthat::expect_equal(to_r(v, from = 2), 2)
  testthat::expect_equal(to_r(v, to = 1), 1)
  testthat::expect_equal(to_r(v, from = 2, to = 2), 2)
})
testthat::test_that("multiset to_r string", {
  v <- cpp_multiset(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v, n = 2), c("hello", "there"))
  testthat::expect_equal(to_r(v, n = -2), c("world", "there"))
  testthat::expect_equal(to_r(v, from = "world"), "world")
  testthat::expect_equal(to_r(v, to = "hello"), "hello")
  testthat::expect_equal(to_r(v, from = "world", to = "world"), "world")
})
testthat::test_that("multiset to_r boolean", {
  v <- cpp_multiset(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), c(FALSE, TRUE))
  testthat::expect_equal(to_r(v, n = 1), FALSE)
  testthat::expect_equal(to_r(v, n = -1), TRUE)
  testthat::expect_equal(to_r(v, from = TRUE), TRUE)
  testthat::expect_equal(to_r(v, to = FALSE), FALSE)
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), TRUE)
})

# unordered_multiset
testthat::test_that("unordered_multiset to_r integer", {
  v <- cpp_unordered_multiset(4:6)
  testthat::expect_setequal(to_r(v), 4:6)
  testthat::expect_length(to_r(v, n = 2), 2L)
})
testthat::test_that("unordered_multiset to_r double", {
  v <- cpp_unordered_multiset(seq.int(1, 2, 0.5))
  testthat::expect_setequal(to_r(v), seq.int(1, 2, 0.5))
  testthat::expect_length(to_r(v, n = 2), 2L)
})
testthat::test_that("unordered_multiset to_r string", {
  v <- cpp_unordered_multiset(c("hello", "there", "world"))
  testthat::expect_setequal(to_r(v), c("hello", "there", "world"))
  testthat::expect_length(to_r(v, n = 2), 2L)
})
testthat::test_that("unordered_multiset to_r boolean", {
  v <- cpp_unordered_multiset(c(TRUE, FALSE))
  testthat::expect_setequal(to_r(v), c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 1), 1L)
})

# map
testthat::test_that("map to_r integer integer", {
  v <- cpp_map(4:6, 8:10)
  testthat::expect_equal(to_r(v), data.frame(key = 4:6, value = 8:10))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = 4:5, value = 8:9))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = 6:5, value = 10:9))
  testthat::expect_equal(to_r(v, from = 6), data.frame(key = 6L, value = 10L))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4L, value = 8L))
  testthat::expect_equal(to_r(v, from = 6, to = 6), data.frame(key = 6L, value = 10L))
})
testthat::test_that("map to_r integer double", {
  v <- cpp_map(4:6, seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), data.frame(key = 4:6, value = seq.int(1, 2, 0.5)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = 4:5, value = seq.int(1, 1.5, 0.5)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = 6:5, value = seq.int(2, 1.5, -0.5)))
  testthat::expect_equal(to_r(v, from = 6), data.frame(key = 6L, value = 2))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4L, value = 1))
  testthat::expect_equal(to_r(v, from = 6, to = 6), data.frame(key = 6L, value = 2))
})
testthat::test_that("map to_r integer string", {
  v <- cpp_map(4:6, c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), data.frame(key = 4:6, value = c("hello", "there", "world")))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = 4:5, value = c("hello", "there")))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = 6:5, value = c("world", "there")))
  testthat::expect_equal(to_r(v, from = 6), data.frame(key = 6L, value = "world"))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4L, value = "hello"))
  testthat::expect_equal(to_r(v, from = 6, to = 6), data.frame(key = 6L, value = "world"))
})
testthat::test_that("map to_r integer boolean", {
  v <- cpp_map(4:6, c(TRUE, FALSE, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = 4:6, value = c(TRUE, FALSE, FALSE)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = 4:5, value = c(TRUE, FALSE)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = 6:5, value = c(FALSE, FALSE)))
  testthat::expect_equal(to_r(v, from = 6), data.frame(key = 6L, value = FALSE))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4L, value = TRUE))
  testthat::expect_equal(to_r(v, from = 6, to = 6), data.frame(key = 6L, value = FALSE))
})
testthat::test_that("map to_r double integer", {
  v <- cpp_map(seq.int(4, 4.2, 0.1), 8:10)
  testthat::expect_equal(to_r(v), data.frame(key = seq.int(4, 4.2, 0.1), value = 8:10))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = seq.int(4, 4.1, 0.1), value = 8:9))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = seq.int(4.2, 4.1, -0.1), value = 10:9))
  testthat::expect_equal(to_r(v, from = 4.2), data.frame(key = 4.2, value = 10L))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4, value = 8L))
  testthat::expect_equal(to_r(v, from = 4.2, to = 4.2), data.frame(key = 4.2, value = 10L))
})
testthat::test_that("map to_r double double", {
  v <- cpp_map(seq.int(4, 4.2, 0.1), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), data.frame(key = seq.int(4, 4.2, 0.1), value = seq.int(1, 2, 0.5)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = seq.int(4, 4.1, 0.1), value = seq.int(1, 1.5, 0.5)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = seq.int(4.2, 4.1, -0.1), value = seq.int(2, 1.5, -0.5)))
  testthat::expect_equal(to_r(v, from = 4.2), data.frame(key = 4.2, value = 2))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4, value = 1))
  testthat::expect_equal(to_r(v, from = 4.2, to = 4.2), data.frame(key = 4.2, value = 2))
})
testthat::test_that("map to_r double string", {
  v <- cpp_map(seq.int(4, 4.2, 0.1), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), data.frame(key = seq.int(4, 4.2, 0.1), value = c("hello", "there", "world")))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = seq.int(4, 4.1, 0.1), value = c("hello", "there")))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = seq.int(4.2, 4.1, -0.1), value = c("world", "there")))
  testthat::expect_equal(to_r(v, from = 4.2), data.frame(key = 4.2, value = "world"))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4, value = "hello"))
  testthat::expect_equal(to_r(v, from = 4.2, to = 4.2), data.frame(key = 4.2, value = "world"))
})
testthat::test_that("map to_r double boolean", {
  v <- cpp_map(seq.int(4, 4.2, 0.1), c(TRUE, FALSE, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = seq.int(4, 4.2, 0.1), value = c(TRUE, FALSE, FALSE)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = seq.int(4, 4.1, 0.1), value = c(TRUE, FALSE)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = seq.int(4.2, 4.1, -0.1), value = c(FALSE, FALSE)))
  testthat::expect_equal(to_r(v, from = 4.2), data.frame(key = 4.2, value = FALSE))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4, value = TRUE))
  testthat::expect_equal(to_r(v, from = 4.2, to = 4.2), data.frame(key = 4.2, value = FALSE))
})
testthat::test_that("map to_r string integer", {
  v <- cpp_map(c("a", "quick", "test"), 8:10)
  testthat::expect_equal(to_r(v), data.frame(key = c("a", "quick", "test"), value = 8:10))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = c("a", "quick"), value = 8:9))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = c("test", "quick"), value = 10:9))
  testthat::expect_equal(to_r(v, from = "test"), data.frame(key = "test", value = 10L))
  testthat::expect_equal(to_r(v, to = "a"), data.frame(key = "a", value = 8L))
  testthat::expect_equal(to_r(v, from = "test", to = "test"), data.frame(key = "test", value = 10L))
})
testthat::test_that("map to_r string double", {
  v <- cpp_map(c("a", "quick", "test"), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), data.frame(key = c("a", "quick", "test"), value = seq.int(1, 2, 0.5)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = c("a", "quick"), value = seq.int(1, 1.5, 0.5)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = c("test", "quick"), value = seq.int(2, 1.5, -0.5)))
  testthat::expect_equal(to_r(v, from = "test"), data.frame(key = "test", value = 2))
  testthat::expect_equal(to_r(v, to = "a"), data.frame(key = "a", value = 1))
  testthat::expect_equal(to_r(v, from = "test", to = "test"), data.frame(key = "test", value = 2))
})
testthat::test_that("map to_r string string", {
  v <- cpp_map(c("a", "quick", "test"), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), data.frame(key = c("a", "quick", "test"), value = c("hello", "there", "world")))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = c("a", "quick"), value = c("hello", "there")))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = c("test", "quick"), value = c("world", "there")))
  testthat::expect_equal(to_r(v, from = "test"), data.frame(key = "test", value = "world"))
  testthat::expect_equal(to_r(v, to = "a"), data.frame(key = "a", value = "hello"))
  testthat::expect_equal(to_r(v, from = "test", to = "test"), data.frame(key = "test", value = "world"))
})
testthat::test_that("map to_r string boolean", {
  v <- cpp_map(c("a", "quick", "test"), c(TRUE, FALSE, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = c("a", "quick", "test"), value = c(TRUE, FALSE, FALSE)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = c("a", "quick"), value = c(TRUE, FALSE)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = c("test", "quick"), value = c(FALSE, FALSE)))
  testthat::expect_equal(to_r(v, from = "test"), data.frame(key = "test", value = FALSE))
  testthat::expect_equal(to_r(v, to = "a"), data.frame(key = "a", value = TRUE))
  testthat::expect_equal(to_r(v, from = "test", to = "test"), data.frame(key = "test", value = FALSE))
})
testthat::test_that("map to_r boolean integer", {
  v <- cpp_map(c(TRUE, FALSE), 8:9)
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = 9:8))
  testthat::expect_equal(to_r(v, n = 1), data.frame(key = FALSE, value = 9L))
  testthat::expect_equal(to_r(v, n = -1), data.frame(key = TRUE, value = 8L))
  testthat::expect_equal(to_r(v, from = TRUE), data.frame(key = TRUE, value = 8L))
  testthat::expect_equal(to_r(v, to = FALSE), data.frame(key = FALSE, value = 9L))
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), data.frame(key = TRUE, value = 8L))
})
testthat::test_that("map to_r boolean double", {
  v <- cpp_map(c(TRUE, FALSE), seq.int(1, 1.5, 0.5))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = seq.int(1.5, 1, -0.5)))
  testthat::expect_equal(to_r(v, n = 1), data.frame(key = FALSE, value = 1.5))
  testthat::expect_equal(to_r(v, n = -1), data.frame(key = TRUE, value = 1))
  testthat::expect_equal(to_r(v, from = TRUE), data.frame(key = TRUE, value = 1))
  testthat::expect_equal(to_r(v, to = FALSE), data.frame(key = FALSE, value = 1.5))
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), data.frame(key = TRUE, value = 1))
})
testthat::test_that("map to_r boolean string", {
  v <- cpp_map(c(TRUE, FALSE), c("hello", "there"))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = c("there", "hello")))
  testthat::expect_equal(to_r(v, n = 1), data.frame(key = FALSE, value = "there"))
  testthat::expect_equal(to_r(v, n = -1), data.frame(key = TRUE, value = "hello"))
  testthat::expect_equal(to_r(v, from = TRUE), data.frame(key = TRUE, value = "hello"))
  testthat::expect_equal(to_r(v, to = FALSE), data.frame(key = FALSE, value = "there"))
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), data.frame(key = TRUE, value = "hello"))
})
testthat::test_that("map to_r boolean boolean", {
  v <- cpp_map(c(TRUE, FALSE), c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = c(FALSE, TRUE)))
  testthat::expect_equal(to_r(v, n = 1), data.frame(key = FALSE, value = FALSE))
  testthat::expect_equal(to_r(v, n = -1), data.frame(key = TRUE, value = TRUE))
  testthat::expect_equal(to_r(v, from = TRUE), data.frame(key = TRUE, value = TRUE))
  testthat::expect_equal(to_r(v, to = FALSE), data.frame(key = FALSE, value = FALSE))
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), data.frame(key = TRUE, value = TRUE))
})

# unordered_map
testthat::test_that("unordered_map to_r integer integer", {
  v <- cpp_unordered_map(4:6, 8:10)
  testthat::expect_setequal(to_r(v)$key, 4:6)
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r integer double", {
  v <- cpp_unordered_map(4:6, seq.int(1, 2, 0.5))
  testthat::expect_setequal(to_r(v)$key, 4:6)
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r integer string", {
  v <- cpp_unordered_map(4:6, c("hello", "there", "world"))
  testthat::expect_setequal(to_r(v)$key, 4:6)
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r integer boolean", {
  v <- cpp_unordered_map(4:6, c(TRUE, FALSE, FALSE))
  testthat::expect_setequal(to_r(v)$key, 4:6)
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r double integer", {
  v <- cpp_unordered_map(seq.int(4, 4.2, 0.1), 8:10)
  testthat::expect_setequal(to_r(v)$key, seq.int(4, 4.2, 0.1))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r double double", {
  v <- cpp_unordered_map(seq.int(4, 4.2, 0.1), seq.int(1, 2, 0.5))
  testthat::expect_setequal(to_r(v)$key, seq.int(4, 4.2, 0.1))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r double string", {
  v <- cpp_unordered_map(seq.int(4, 4.2, 0.1), c("hello", "there", "world"))
  testthat::expect_setequal(to_r(v)$key, seq.int(4, 4.2, 0.1))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r double boolean", {
  v <- cpp_unordered_map(seq.int(4, 4.2, 0.1), c(TRUE, FALSE, FALSE))
  testthat::expect_setequal(to_r(v)$key, seq.int(4, 4.2, 0.1))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r string integer", {
  v <- cpp_unordered_map(c("a", "quick", "test"), 8:10)
  testthat::expect_setequal(to_r(v)$key, c("a", "quick", "test"))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r string double", {
  v <- cpp_unordered_map(c("a", "quick", "test"), seq.int(1, 2, 0.5))
  testthat::expect_setequal(to_r(v)$key, c("a", "quick", "test"))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r string string", {
  v <- cpp_unordered_map(c("a", "quick", "test"), c("hello", "there", "world"))
  testthat::expect_setequal(to_r(v)$key, c("a", "quick", "test"))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r string boolean", {
  v <- cpp_unordered_map(c("a", "quick", "test"), c(TRUE, FALSE, FALSE))
  testthat::expect_setequal(to_r(v)$key, c("a", "quick", "test"))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r boolean integer", {
  v <- cpp_unordered_map(c(TRUE, FALSE), 8:9)
  testthat::expect_setequal(to_r(v)$key, c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r boolean double", {
  v <- cpp_unordered_map(c(TRUE, FALSE), seq.int(1, 1.5, 0.5))
  testthat::expect_setequal(to_r(v)$key, c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r boolean string", {
  v <- cpp_unordered_map(c(TRUE, FALSE), c("hello", "there"))
  testthat::expect_setequal(to_r(v)$key, c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_map to_r boolean boolean", {
  v <- cpp_unordered_map(c(TRUE, FALSE), c(TRUE, FALSE))
  testthat::expect_setequal(to_r(v)$key, c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})

# multimap
testthat::test_that("multimap to_r integer integer", {
  v <- cpp_multimap(4:6, 8:10)
  testthat::expect_equal(to_r(v), data.frame(key = 4:6, value = 8:10))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = 4:5, value = 8:9))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = 6:5, value = 10:9))
  testthat::expect_equal(to_r(v, from = 6), data.frame(key = 6L, value = 10L))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4L, value = 8L))
  testthat::expect_equal(to_r(v, from = 6, to = 6), data.frame(key = 6L, value = 10L))
})
testthat::test_that("multimap to_r integer double", {
  v <- cpp_multimap(4:6, seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), data.frame(key = 4:6, value = seq.int(1, 2, 0.5)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = 4:5, value = seq.int(1, 1.5, 0.5)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = 6:5, value = seq.int(2, 1.5, -0.5)))
  testthat::expect_equal(to_r(v, from = 6), data.frame(key = 6L, value = 2))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4L, value = 1))
  testthat::expect_equal(to_r(v, from = 6, to = 6), data.frame(key = 6L, value = 2))
})
testthat::test_that("multimap to_r integer string", {
  v <- cpp_multimap(4:6, c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), data.frame(key = 4:6, value = c("hello", "there", "world")))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = 4:5, value = c("hello", "there")))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = 6:5, value = c("world", "there")))
  testthat::expect_equal(to_r(v, from = 6), data.frame(key = 6L, value = "world"))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4L, value = "hello"))
  testthat::expect_equal(to_r(v, from = 6, to = 6), data.frame(key = 6L, value = "world"))
})
testthat::test_that("multimap to_r integer boolean", {
  v <- cpp_multimap(4:6, c(TRUE, FALSE, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = 4:6, value = c(TRUE, FALSE, FALSE)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = 4:5, value = c(TRUE, FALSE)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = 6:5, value = c(FALSE, FALSE)))
  testthat::expect_equal(to_r(v, from = 6), data.frame(key = 6L, value = FALSE))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4L, value = TRUE))
  testthat::expect_equal(to_r(v, from = 6, to = 6), data.frame(key = 6L, value = FALSE))
})
testthat::test_that("multimap to_r double integer", {
  v <- cpp_multimap(seq.int(4, 4.2, 0.1), 8:10)
  testthat::expect_equal(to_r(v), data.frame(key = seq.int(4, 4.2, 0.1), value = 8:10))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = seq.int(4, 4.1, 0.1), value = 8:9))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = seq.int(4.2, 4.1, -0.1), value = 10:9))
  testthat::expect_equal(to_r(v, from = 4.2), data.frame(key = 4.2, value = 10L))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4, value = 8L))
  testthat::expect_equal(to_r(v, from = 4.2, to = 4.2), data.frame(key = 4.2, value = 10L))
})
testthat::test_that("multimap to_r double double", {
  v <- cpp_multimap(seq.int(4, 4.2, 0.1), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), data.frame(key = seq.int(4, 4.2, 0.1), value = seq.int(1, 2, 0.5)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = seq.int(4, 4.1, 0.1), value = seq.int(1, 1.5, 0.5)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = seq.int(4.2, 4.1, -0.1), value = seq.int(2, 1.5, -0.5)))
  testthat::expect_equal(to_r(v, from = 4.2), data.frame(key = 4.2, value = 2))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4, value = 1))
  testthat::expect_equal(to_r(v, from = 4.2, to = 4.2), data.frame(key = 4.2, value = 2))
})
testthat::test_that("multimap to_r double string", {
  v <- cpp_multimap(seq.int(4, 4.2, 0.1), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), data.frame(key = seq.int(4, 4.2, 0.1), value = c("hello", "there", "world")))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = seq.int(4, 4.1, 0.1), value = c("hello", "there")))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = seq.int(4.2, 4.1, -0.1), value = c("world", "there")))
  testthat::expect_equal(to_r(v, from = 4.2), data.frame(key = 4.2, value = "world"))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4, value = "hello"))
  testthat::expect_equal(to_r(v, from = 4.2, to = 4.2), data.frame(key = 4.2, value = "world"))
})
testthat::test_that("multimap to_r double boolean", {
  v <- cpp_multimap(seq.int(4, 4.2, 0.1), c(TRUE, FALSE, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = seq.int(4, 4.2, 0.1), value = c(TRUE, FALSE, FALSE)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = seq.int(4, 4.1, 0.1), value = c(TRUE, FALSE)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = seq.int(4.2, 4.1, -0.1), value = c(FALSE, FALSE)))
  testthat::expect_equal(to_r(v, from = 4.2), data.frame(key = 4.2, value = FALSE))
  testthat::expect_equal(to_r(v, to = 4), data.frame(key = 4, value = TRUE))
  testthat::expect_equal(to_r(v, from = 4.2, to = 4.2), data.frame(key = 4.2, value = FALSE))
})
testthat::test_that("multimap to_r string integer", {
  v <- cpp_multimap(c("a", "quick", "test"), 8:10)
  testthat::expect_equal(to_r(v), data.frame(key = c("a", "quick", "test"), value = 8:10))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = c("a", "quick"), value = 8:9))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = c("test", "quick"), value = 10:9))
  testthat::expect_equal(to_r(v, from = "test"), data.frame(key = "test", value = 10L))
  testthat::expect_equal(to_r(v, to = "a"), data.frame(key = "a", value = 8L))
  testthat::expect_equal(to_r(v, from = "test", to = "test"), data.frame(key = "test", value = 10L))
})
testthat::test_that("multimap to_r string double", {
  v <- cpp_multimap(c("a", "quick", "test"), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), data.frame(key = c("a", "quick", "test"), value = seq.int(1, 2, 0.5)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = c("a", "quick"), value = seq.int(1, 1.5, 0.5)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = c("test", "quick"), value = seq.int(2, 1.5, -0.5)))
  testthat::expect_equal(to_r(v, from = "test"), data.frame(key = "test", value = 2))
  testthat::expect_equal(to_r(v, to = "a"), data.frame(key = "a", value = 1))
  testthat::expect_equal(to_r(v, from = "test", to = "test"), data.frame(key = "test", value = 2))
})
testthat::test_that("multimap to_r string string", {
  v <- cpp_multimap(c("a", "quick", "test"), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), data.frame(key = c("a", "quick", "test"), value = c("hello", "there", "world")))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = c("a", "quick"), value = c("hello", "there")))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = c("test", "quick"), value = c("world", "there")))
  testthat::expect_equal(to_r(v, from = "test"), data.frame(key = "test", value = "world"))
  testthat::expect_equal(to_r(v, to = "a"), data.frame(key = "a", value = "hello"))
  testthat::expect_equal(to_r(v, from = "test", to = "test"), data.frame(key = "test", value = "world"))
})
testthat::test_that("multimap to_r string boolean", {
  v <- cpp_multimap(c("a", "quick", "test"), c(TRUE, FALSE, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = c("a", "quick", "test"), value = c(TRUE, FALSE, FALSE)))
  testthat::expect_equal(to_r(v, n = 2), data.frame(key = c("a", "quick"), value = c(TRUE, FALSE)))
  testthat::expect_equal(to_r(v, n = -2), data.frame(key = c("test", "quick"), value = c(FALSE, FALSE)))
  testthat::expect_equal(to_r(v, from = "test"), data.frame(key = "test", value = FALSE))
  testthat::expect_equal(to_r(v, to = "a"), data.frame(key = "a", value = TRUE))
  testthat::expect_equal(to_r(v, from = "test", to = "test"), data.frame(key = "test", value = FALSE))
})
testthat::test_that("multimap to_r boolean integer", {
  v <- cpp_multimap(c(TRUE, FALSE), 8:9)
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = 9:8))
  testthat::expect_equal(to_r(v, n = 1), data.frame(key = FALSE, value = 9L))
  testthat::expect_equal(to_r(v, n = -1), data.frame(key = TRUE, value = 8L))
  testthat::expect_equal(to_r(v, from = TRUE), data.frame(key = TRUE, value = 8L))
  testthat::expect_equal(to_r(v, to = FALSE), data.frame(key = FALSE, value = 9L))
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), data.frame(key = TRUE, value = 8L))
})
testthat::test_that("multimap to_r boolean double", {
  v <- cpp_multimap(c(TRUE, FALSE), seq.int(1, 1.5, 0.5))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = seq.int(1.5, 1, -0.5)))
  testthat::expect_equal(to_r(v, n = 1), data.frame(key = FALSE, value = 1.5))
  testthat::expect_equal(to_r(v, n = -1), data.frame(key = TRUE, value = 1))
  testthat::expect_equal(to_r(v, from = TRUE), data.frame(key = TRUE, value = 1))
  testthat::expect_equal(to_r(v, to = FALSE), data.frame(key = FALSE, value = 1.5))
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), data.frame(key = TRUE, value = 1))
})
testthat::test_that("multimap to_r boolean string", {
  v <- cpp_multimap(c(TRUE, FALSE), c("hello", "there"))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = c("there", "hello")))
  testthat::expect_equal(to_r(v, n = 1), data.frame(key = FALSE, value = "there"))
  testthat::expect_equal(to_r(v, n = -1), data.frame(key = TRUE, value = "hello"))
  testthat::expect_equal(to_r(v, from = TRUE), data.frame(key = TRUE, value = "hello"))
  testthat::expect_equal(to_r(v, to = FALSE), data.frame(key = FALSE, value = "there"))
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), data.frame(key = TRUE, value = "hello"))
})
testthat::test_that("multimap to_r boolean boolean", {
  v <- cpp_multimap(c(TRUE, FALSE), c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), data.frame(key = c(FALSE, TRUE), value = c(FALSE, TRUE)))
  testthat::expect_equal(to_r(v, n = 1), data.frame(key = FALSE, value = FALSE))
  testthat::expect_equal(to_r(v, n = -1), data.frame(key = TRUE, value = TRUE))
  testthat::expect_equal(to_r(v, from = TRUE), data.frame(key = TRUE, value = TRUE))
  testthat::expect_equal(to_r(v, to = FALSE), data.frame(key = FALSE, value = FALSE))
  testthat::expect_equal(to_r(v, from = TRUE, to = TRUE), data.frame(key = TRUE, value = TRUE))
})

# unordered_multimap
testthat::test_that("unordered_multimap to_r integer integer", {
  v <- cpp_unordered_multimap(4:6, 8:10)
  testthat::expect_setequal(to_r(v)$key, 4:6)
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r integer double", {
  v <- cpp_unordered_multimap(4:6, seq.int(1, 2, 0.5))
  testthat::expect_setequal(to_r(v)$key, 4:6)
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r integer string", {
  v <- cpp_unordered_multimap(4:6, c("hello", "there", "world"))
  testthat::expect_setequal(to_r(v)$key, 4:6)
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r integer boolean", {
  v <- cpp_unordered_multimap(4:6, c(TRUE, FALSE, FALSE))
  testthat::expect_setequal(to_r(v)$key, 4:6)
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r double integer", {
  v <- cpp_unordered_multimap(seq.int(4, 4.2, 0.1), 8:10)
  testthat::expect_setequal(to_r(v)$key, seq.int(4, 4.2, 0.1))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r double double", {
  v <- cpp_unordered_multimap(seq.int(4, 4.2, 0.1), seq.int(1, 2, 0.5))
  testthat::expect_setequal(to_r(v)$key, seq.int(4, 4.2, 0.1))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r double string", {
  v <- cpp_unordered_multimap(seq.int(4, 4.2, 0.1), c("hello", "there", "world"))
  testthat::expect_setequal(to_r(v)$key, seq.int(4, 4.2, 0.1))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r double boolean", {
  v <- cpp_unordered_multimap(seq.int(4, 4.2, 0.1), c(TRUE, FALSE, FALSE))
  testthat::expect_setequal(to_r(v)$key, seq.int(4, 4.2, 0.1))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r string integer", {
  v <- cpp_unordered_multimap(c("a", "quick", "test"), 8:10)
  testthat::expect_setequal(to_r(v)$key, c("a", "quick", "test"))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r string double", {
  v <- cpp_unordered_multimap(c("a", "quick", "test"), seq.int(1, 2, 0.5))
  testthat::expect_setequal(to_r(v)$key, c("a", "quick", "test"))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r string string", {
  v <- cpp_unordered_multimap(c("a", "quick", "test"), c("hello", "there", "world"))
  testthat::expect_setequal(to_r(v)$key, c("a", "quick", "test"))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r string boolean", {
  v <- cpp_unordered_multimap(c("a", "quick", "test"), c(TRUE, FALSE, FALSE))
  testthat::expect_setequal(to_r(v)$key, c("a", "quick", "test"))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r boolean integer", {
  v <- cpp_unordered_multimap(c(TRUE, FALSE), 8:9)
  testthat::expect_setequal(to_r(v)$key, c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r boolean double", {
  v <- cpp_unordered_multimap(c(TRUE, FALSE), seq.int(1, 1.5, 0.5))
  testthat::expect_setequal(to_r(v)$key, c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r boolean string", {
  v <- cpp_unordered_multimap(c(TRUE, FALSE), c("hello", "there"))
  testthat::expect_setequal(to_r(v)$key, c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})
testthat::test_that("unordered_multimap to_r boolean boolean", {
  v <- cpp_unordered_multimap(c(TRUE, FALSE), c(TRUE, FALSE))
  testthat::expect_setequal(to_r(v)$key, c(FALSE, TRUE))
  testthat::expect_length(to_r(v, n = 2)$key, 2L)
})

# stack
testthat::test_that("stack to_r integer", {
  v <- cpp_stack(4:6)
  testthat::expect_equal(to_r(v), 6:4)
  v <- cpp_stack(4:6)
  testthat::expect_equal(to_r(v, n = 2), 6:5)
})
testthat::test_that("stack to_r double", {
  v <- cpp_stack(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), seq.int(2, 1, -0.5))
  v <- cpp_stack(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v, n = 2), seq.int(2, 1.5, -0.5))
})
testthat::test_that("stack to_r string", {
  v <- cpp_stack(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), c("world", "there", "hello"))
  v <- cpp_stack(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v, n = 2), c("world", "there"))
})
testthat::test_that("stack to_r boolean", {
  v <- cpp_stack(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), c(FALSE, TRUE))
  v <- cpp_stack(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v, n = 1), FALSE)
})

# queue
testthat::test_that("queue to_r integer", {
  v <- cpp_queue(4:6)
  testthat::expect_equal(to_r(v), 4:6)
  v <- cpp_queue(4:6)
  testthat::expect_equal(to_r(v, n = 2), 4:5)
})
testthat::test_that("queue to_r double", {
  v <- cpp_queue(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
  v <- cpp_queue(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v, n = 2), seq.int(1, 1.5, 0.5))
})
testthat::test_that("queue to_r string", {
  v <- cpp_queue(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
  v <- cpp_queue(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v, n = 2), c("hello", "there"))
})
testthat::test_that("queue to_r boolean", {
  v <- cpp_queue(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE))
  v <- cpp_queue(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v, n = 1), TRUE)
})

# priority_queue
testthat::test_that("priority_queue to_r integer descending", {
  v <- cpp_priority_queue(4:6)
  testthat::expect_equal(to_r(v), 6:4)
  v <- cpp_priority_queue(4:6)
  testthat::expect_equal(to_r(v, n = 2), 6:5)
})
testthat::test_that("priority_queue to_r double descending", {
  v <- cpp_priority_queue(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), seq.int(2, 1, -0.5))
  v <- cpp_priority_queue(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v, n = 2), seq.int(2, 1.5, -0.5))
})
testthat::test_that("priority_queue to_r string descending", {
  v <- cpp_priority_queue(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), c("world", "there", "hello"))
  v <- cpp_priority_queue(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v, n = 2), c("world", "there"))
})
testthat::test_that("priority_queue to_r boolean descending", {
  v <- cpp_priority_queue(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE))
  v <- cpp_priority_queue(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v, n = 1), TRUE)
})
testthat::test_that("priority_queue to_r integer ascending", {
  v <- cpp_priority_queue(4:6, "ascending")
  testthat::expect_equal(to_r(v), 4:6)
  v <- cpp_priority_queue(4:6, "ascending")
  testthat::expect_equal(to_r(v, n = 2), 4:5)
})
testthat::test_that("priority_queue to_r double ascending", {
  v <- cpp_priority_queue(seq.int(1, 2, 0.5), "ascending")
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
  v <- cpp_priority_queue(seq.int(1, 2, 0.5), "ascending")
  testthat::expect_equal(to_r(v, n = 2), seq.int(1, 1.5, 0.5))
})
testthat::test_that("priority_queue to_r string ascending", {
  v <- cpp_priority_queue(c("hello", "there", "world"), "ascending")
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
  v <- cpp_priority_queue(c("hello", "there", "world"), "ascending")
  testthat::expect_equal(to_r(v, n = 2), c("hello", "there"))
})
testthat::test_that("priority_queue to_r boolean ascending", {
  v <- cpp_priority_queue(c(TRUE, FALSE), "ascending")
  testthat::expect_equal(to_r(v), c(FALSE, TRUE))
  v <- cpp_priority_queue(c(TRUE, FALSE), "ascending")
  testthat::expect_equal(to_r(v, n = 1), FALSE)
})

# vector
testthat::test_that("vector to_r integer", {
  v <- cpp_vector(4:6)
  testthat::expect_equal(to_r(v), 4:6)
  testthat::expect_equal(to_r(v, n = 2), 4:5)
  testthat::expect_equal(to_r(v, n = -2), 6:5)
  testthat::expect_equal(to_r(v, from = 3L), 6L)
  testthat::expect_equal(to_r(v, to = 1L), 4L)
  testthat::expect_equal(to_r(v, from = 3L, to = 3L), 6L)
})
testthat::test_that("vector to_r double", {
  v <- cpp_vector(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v, n = 2), seq.int(1, 1.5, 0.5))
  testthat::expect_equal(to_r(v, n = -2), seq.int(2, 1.5, -0.5))
  testthat::expect_equal(to_r(v, from = 3L), 2)
  testthat::expect_equal(to_r(v, to = 1L), 1)
  testthat::expect_equal(to_r(v, from = 3L, to = 3L), 2)
})
testthat::test_that("vector to_r string", {
  v <- cpp_vector(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v, n = 2), c("hello", "there"))
  testthat::expect_equal(to_r(v, n = -2), c("world", "there"))
  testthat::expect_equal(to_r(v, from = 3L), "world")
  testthat::expect_equal(to_r(v, to = 1L), "hello")
  testthat::expect_equal(to_r(v, from = 3L, to = 3L), "world")
})
testthat::test_that("vector to_r boolean", {
  v <- cpp_vector(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE))
  testthat::expect_equal(to_r(v, n = 1), TRUE)
  testthat::expect_equal(to_r(v, n = -1), FALSE)
  testthat::expect_equal(to_r(v, from = 2L), FALSE)
  testthat::expect_equal(to_r(v, to = 1L), TRUE)
  testthat::expect_equal(to_r(v, from = 2L, to = 2L), FALSE)
})

# deque
testthat::test_that("deque to_r integer", {
  v <- cpp_deque(4:6)
  testthat::expect_equal(to_r(v), 4:6)
  testthat::expect_equal(to_r(v, n = 2), 4:5)
  testthat::expect_equal(to_r(v, n = -2), 6:5)
  testthat::expect_equal(to_r(v, from = 3L), 6L)
  testthat::expect_equal(to_r(v, to = 1L), 4L)
  testthat::expect_equal(to_r(v, from = 3L, to = 3L), 6L)
})
testthat::test_that("deque to_r double", {
  v <- cpp_deque(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v, n = 2), seq.int(1, 1.5, 0.5))
  testthat::expect_equal(to_r(v, n = -2), seq.int(2, 1.5, -0.5))
  testthat::expect_equal(to_r(v, from = 3L), 2)
  testthat::expect_equal(to_r(v, to = 1L), 1)
  testthat::expect_equal(to_r(v, from = 3L, to = 3L), 2)
})
testthat::test_that("deque to_r string", {
  v <- cpp_deque(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v, n = 2), c("hello", "there"))
  testthat::expect_equal(to_r(v, n = -2), c("world", "there"))
  testthat::expect_equal(to_r(v, from = 3L), "world")
  testthat::expect_equal(to_r(v, to = 1L), "hello")
  testthat::expect_equal(to_r(v, from = 3L, to = 3L), "world")
})
testthat::test_that("deque to_r boolean", {
  v <- cpp_deque(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE))
  testthat::expect_equal(to_r(v, n = 1), TRUE)
  testthat::expect_equal(to_r(v, n = -1), FALSE)
  testthat::expect_equal(to_r(v, from = 2L), FALSE)
  testthat::expect_equal(to_r(v, to = 1L), TRUE)
  testthat::expect_equal(to_r(v, from = 2L, to = 2L), FALSE)
})

# forward_list
testthat::test_that("forward_list to_r integer", {
  v <- cpp_forward_list(4:6)
  testthat::expect_equal(to_r(v), 4:6)
  testthat::expect_equal(to_r(v, n = 2), 4:5)
  testthat::expect_error(to_r(v, n = -2))
})
testthat::test_that("forward_list to_r double", {
  v <- cpp_forward_list(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v, n = 2), seq.int(1, 1.5, 0.5))
  testthat::expect_error(to_r(v, n = -2))
})
testthat::test_that("forward_list to_r string", {
  v <- cpp_forward_list(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v, n = 2), c("hello", "there"))
  testthat::expect_error(to_r(v, n = -2))
})
testthat::test_that("forward_list to_r boolean", {
  v <- cpp_forward_list(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE))
  testthat::expect_equal(to_r(v, n = 1), TRUE)
  testthat::expect_error(to_r(v, n = -1))
})

# list
testthat::test_that("list to_r integer", {
  v <- cpp_list(4:6)
  testthat::expect_equal(to_r(v), 4:6)
  testthat::expect_equal(to_r(v, n = 2), 4:5)
  testthat::expect_equal(to_r(v, n = -2), 6:5)
})
testthat::test_that("list to_r double", {
  v <- cpp_list(seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v), seq.int(1, 2, 0.5))
  testthat::expect_equal(to_r(v, n = 2), seq.int(1, 1.5, 0.5))
  testthat::expect_equal(to_r(v, n = -2), seq.int(2, 1.5, -0.5))
})
testthat::test_that("list to_r string", {
  v <- cpp_list(c("hello", "there", "world"))
  testthat::expect_equal(to_r(v), c("hello", "there", "world"))
  testthat::expect_equal(to_r(v, n = 2), c("hello", "there"))
  testthat::expect_equal(to_r(v, n = -2), c("world", "there"))
})
testthat::test_that("list to_r boolean", {
  v <- cpp_list(c(TRUE, FALSE))
  testthat::expect_equal(to_r(v), c(TRUE, FALSE))
  testthat::expect_equal(to_r(v, n = 1), TRUE)
  testthat::expect_equal(to_r(v, n = -1), FALSE)
})
