% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json2html.R
\name{json2html}
\alias{json2html}
\title{JSON to HTML}
\usage{
json2html(
  json,
  outfile = NULL,
  pandoc = FALSE,
  style = paste0("background-color: #051C55; color: #E76900; ",
    "font-size: 15px; font-weight: bold; margin: 0; ",
    "white-space: pre-wrap; outline: #051C55 solid 10px;"),
  keyColor = "crimson",
  numberColor = "chartreuse",
  stringColor = "lightcoral",
  trueColor = "#00cc00",
  falseColor = "#ff8080",
  nullColor = "cornflowerblue"
)
}
\arguments{
\item{json}{a JSON string or a path to a JSON file}

\item{outfile}{either a path to a html file, or \code{NULL} if you don't
want to write the output to a file}

\item{pandoc}{Boolean, whether to use pandoc}

\item{style}{some CSS for the container, only if \code{pandoc=FALSE}}

\item{keyColor}{color of the keys, only if \code{pandoc=FALSE}}

\item{numberColor}{color of the numbers, only if \code{pandoc=FALSE}}

\item{stringColor}{color of the strings, only if \code{pandoc=FALSE}}

\item{trueColor}{color of the \code{true} keyword, only
if \code{pandoc=FALSE}}

\item{falseColor}{color of the \code{false} keyword, only
if \code{pandoc=FALSE}}

\item{nullColor}{color of the \code{null} keyword, only
if \code{pandoc=FALSE}}
}
\value{
Nothing if \code{outfile} is not \code{NULL}, otherwise the HtML
  as a character string.
}
\description{
Render a formatted JSON string in HTML.
}
\examples{
library(cppcheckR)
xml <- system.file("extdata", "order-schema.xml", package = "xml2")
json <- xml2json(xml)
html <- json2html(json)
library(htmltools)
if(interactive()){
  browsable(HTML(html))
}
# with pandoc
html <- json2html(json, pandoc = TRUE)
if(interactive()){
  browsable(HTML(html))
}
}
