% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{name_to_fips}
\alias{name_to_fips}
\alias{name_to_cbsa}
\title{Get FIPS or CBSA codes from county or metropolitan area names}
\usage{
name_to_fips(
  name,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  ties_method = c("first", "all"),
  state = NULL
)

name_to_cbsa(
  name,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  ties_method = c("first", "all"),
  state = NULL
)
}
\arguments{
\item{name}{Vector of county or metropolitan area names to look up.}

\item{ignore.case, perl, fixed}{Arguments to pass to \code{grep()}, with the same
defaults as in the latter function. Hence, by default, regular expressions
are used; to match against a fixed string (no regular expressions), set
\code{fixed = TRUE}.}

\item{ties_method}{If "first", then only the first match for each name is
returned. If "all", then all matches for each name are returned.}

\item{state}{Two letter state abbreviation (case insensitive) indicating a
parent state used to restrict the search. For example, when \code{state = "NY"},
then \code{name_to_fips()} searches only over only counties lying in New York
state, whereas \code{name_to_cbsa()} searches over the metropolitan areas lying,
either fully or partially (as a metropolitan area can span several states),
in New York state. If \code{NULL}, the default, then the search is performed
US-wide (not restricted to any state in particular).}
}
\value{
A vector of FIPS or CBSA codes if \code{ties_method} equals "first", and a
list of FIPS or CBSA codes otherwise.
}
\description{
Look up FIPS or CBSA codes by county or metropolitan area names,
respectively; these functions are based on \code{grep()}, and hence allow for
regular expressions.
}
\examples{
name_to_fips("Allegheny")
name_to_cbsa("Pittsburgh")
name_to_fips("Miami")
name_to_fips("Miami", ties_method = "all")
name_to_fips(c("Allegheny", "Miami", "New "), ties_method = "all")

}
\seealso{
\code{\link[=state_fips_to_name]{state_fips_to_name()}}, \code{\link[=cbsa_to_name]{cbsa_to_name()}}
}
