% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{abbr_to_name}
\alias{abbr_to_name}
\title{Get state names from state abbreviations}
\usage{
abbr_to_name(
  abbr,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  ties_method = c("first", "all")
)
}
\arguments{
\item{abbr}{Vector of state abbreviations to look up.}

\item{ignore.case, perl, fixed}{Arguments to pass to \code{grep()}, with the same
defaults as in the latter function. Hence, by default, regular expressions
are used; to match against a fixed string (no regular expressions), set
\code{fixed = TRUE}.}

\item{ties_method}{If "first", then only the first match for each name is
returned. If "all", then all matches for each name are returned.}
}
\value{
A vector of state names if \code{ties_method} equals "first", and a list
of state names otherwise.
}
\description{
Look up state names by state abbreviations (including District of Columbia
and Puerto Rico); this function is based on \code{grep()}, and hence allows for
regular expressions.
}
\examples{
abbr_to_name("PA")
abbr_to_name(c("PA", "PR", "DC"))

}
\seealso{
\code{\link[=name_to_abbr]{name_to_abbr()}}
}
