# tests/testthat/test-phonetic.R

test_that("phonetic_shift swaps similar consonants", {
  # v -> f (or vice versa)
  result <- phonetic_shift("coverage", "v")
  expect_equal(result, "coferage")
})

test_that("vowel_shift changes vowels", {
  result <- vowel_shift("test", "e", "i")
  expect_equal(result, "tist")
})

test_that("soundex produces correct codes", {
  expect_equal(soundex("Robert"), "R163")
  expect_equal(soundex("Rupert"), "R163")
  expect_equal(soundex("Washington"), "W252")
})

test_that("phonetic_distance measures similarity", {
  # Same word = 0
  expect_equal(phonetic_distance("hello", "hello"), 0)
  # Similar words < different words
  dist_similar <- phonetic_distance("coverage", "covfefe")
  dist_different <- phonetic_distance("coverage", "elephant")
  expect_true(dist_similar < dist_different)
})

test_that("get_phonetic_group returns correct group", {
  expect_equal(get_phonetic_group("b"), "labial")
  expect_equal(get_phonetic_group("k"), "velar")
  expect_equal(get_phonetic_group("l"), "liquid")
})
