% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/CovFracBM.R
\name{covFracBM}
\alias{covFracBM}
\title{covFracBM}
\usage{
covFracBM(value = c(1, 0.5), form = ~1)
}
\arguments{
\item{value}{Vector of length 2 providing starting values for optimisation of the scale
parameter of fractional Brownian motion process relative to residual error variance and
the Hurst parameter, respectively.}

\item{form}{A one-sided formula of the form ~t|g, where t represents a continuous
variable (usually time) and g represents a grouping factor, i.e. with a separate
fractional Brownian motion process modelled at each level.}
}
\value{
An object of class "covFracBM" and inheriting from "corStruct".
}
\description{
This is a constructor function for the "covFracBM" class, representing a fractional Brownian
motion component in terms of a continuous variable. The object created is a special type of
\code{\link[nlme]{corStruct}}.
}
\examples{
cov2<-covFracBM(form=~time|group)
}

