% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cossonet.R
\name{cossonet}
\alias{cossonet}
\title{Load a matrix from a file}
\usage{
cossonet(
  x,
  y,
  family = c("gaussian", "binomial", "poisson", "Cox"),
  wt = rep(1, ncol(x)),
  scale = TRUE,
  nbasis,
  basis.id,
  kernel = c("linear", "gaussian", "poly", "spline"),
  effect = c("main", "interaction"),
  nfold = 5,
  kparam = 1,
  lambda0 = exp(seq(log(2^{
     -10
 }), log(2^{
     10
 }), length.out = 20)),
  lambda_theta = exp(seq(log(2^{
     -10
 }), log(2^{
     10
 }), length.out = 20)),
  gamma = 0.95,
  one.std = TRUE
)
}
\arguments{
\item{x}{Input matrix or data frame of $n$ by $p$. \code{x} must have at least two columns ($p>1$).}

\item{y}{A response vector with a continuous, binary, or count type. For survival responses, this should be a two-column matrix (or data frame) with columns called 'time' and 'status'.}

\item{family}{A distribution corresponding to the response type. \code{family="gaussian"} for continuous responses, \code{family="binomial"} for binary responses, \code{family="poisson"} for count responses, and \code{family="cox"} for survival responses.}

\item{wt}{The weights assigned to the explanatory variables. The default is \code{rep(1,ncol(x))}.}

\item{scale}{Boolean for whether to scale continuous explanatory variables to values between 0 and 1.}

\item{nbasis}{The number of "knots". If \code{basis.id} is provided, it is set to the length of \code{basis.id}.}

\item{basis.id}{The index of the "knot" to select.}

\item{kernel}{TThe kernel function. One of four types of \code{linear} (default), \code{gaussian}, \code{poly}, and \code{spline}.}

\item{effect}{The effect of the component. \code{main} (default) is the main effect, and \code{interaction} is the two-way interaction.}

\item{nfold}{The number of folds to use in cross-validation is used to determine how many subsets to divide the data into for the training and validation sets.}

\item{kparam}{Parameters for Gaussian and polynomial kernel functions}

\item{lambda0}{A vector of \code{lambda0} sequences. The default is a grid of 20 values \verb{[2^\{-10\}, \\dots, 2^\{10\}]} on an equally spaced logarithmic scale. This may need to be adjusted based on the input data. Do not set \verb{\\lambda0} as a single value.}

\item{lambda_theta}{A vector of \code{lambda} sequences. The default is a grid of 20 values \verb{[2^\{-10\}, \\dots, 2^\{10\}]} on an equally spaced logarithmic scale. This may need to be adjusted based on the input data. Do not set \code{lambda} as a single value.}

\item{gamma}{Elastic-net mixing parameter \verb{0 \\leq \\gamma \\leq 1}. If \code{gamma = 1}, the LASSO penalty is applied, and if \code{gamma = 0}, the Ridge penalty is applied. The default is \code{gamma = 0.95}.}

\item{one.std}{A logical value indicating whether to apply the "1-standard error rule." When set to \code{TRUE}, it applies to both the c-step and theta-step, selecting the simplest model within one standard error of the best model.}
}
\value{
A list containing information about the fitted model.
}
\description{
The cossonet function implements a nonparametric regression model that estimates nonlinear components.
This function can be applied to continuous, count, binary, and survival responses.
To use this function, the user must specify a family, kernel function, etc. For cross-validation, the sequence vectors \code{lambda0} and \code{lambda_theta} appropriate for the input data must also be specified.
}
\examples{
\donttest{
# Generate example data
set.seed(20250101)
tr = data_generation(n = 200, p = 20, SNR = 9, response = "continuous")
tr_x = tr$x
tr_y = tr$y

te = data_generation(n = 1000, p = 20, SNR = 9, response = "continuous")
te_x = te$x
te_y = te$y

# Fit the model
fit = cossonet(tr_x, tr_y, family = 'gaussian', gamma = 0.95, kernel = "spline", scale = TRUE,
      lambda0 = exp(seq(log(2^{-4}), log(2^{0}), length.out = 20)),
      lambda_theta = exp(seq(log(2^{-8}), log(2^{-6}), length.out = 20))
      )

}
}
