% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlbinom.R
\name{correlbinom}
\alias{correlbinom}
\title{Correlated Binomial Probabilities}
\usage{
correlbinom(rho, successprob, trials, precision = 1024, model = "witt")
}
\arguments{
\item{rho}{The level of correlation or association between trials. In the Witt (2014) model, this parameter is the level of correlation between trials. In the Kuk (2004) model, it is the equivalent of one minus gamma from that paper, where a value of zero indicates independence. In both cases, this parameter must fall within the unit interval.}

\item{successprob}{The likelihood of success in one trial.}

\item{trials}{The number of trials.}

\item{precision}{Number of bits of precision. Defaults to 1024.}

\item{model}{Specify whether the 'kuk' or 'witt' model is to be used for calculation. Defaults to 'witt'.}
}
\description{
This function reports the likelihoods of 0, 1, ..., n
successes given n trials of a binomial with a specified
correlation or association between trials and success
probability
}
\examples{
correlbinom(0.5,0.1,5)
correlbinom(0.9,0.3,12,256)
correlbinom(0.9,0.6,12,model="kuk")
}
\references{
Kuk, Anthony Y. C., 2004. A litter-based approach to risk assessment in developmental toxicity via a power family of completely monotone functions. \emph{Journal of the Royal Statistical Society, Series C (Applied Statistics)}, \emph{53}(2): 369-86.

Witt, Gary, 2014. A simple distribution for the sum of correlated, exchangeable binary data. \emph{Communications in Statistics - Theory and Methods}, \emph{43}(20): 4265-80.
}
