% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rao.R
\name{raotest}
\alias{raotest}
\title{Rao-type chi-squared test (model-based or robust)}
\usage{
raotest(mod, mod_null)
}
\arguments{
\item{mod}{an object of class \code{bbdml}}

\item{mod_null}{an object of class \code{bbdml}, should be nested within \code{mod}}
}
\value{
P-value from likelihood ratio test.
}
\description{
Rao-type chi-squared test (model-based or robust)
}
\examples{
data(soil_phylum_small_otu1)
mod1 <- bbdml(formula = cbind(W, M - W) ~ DayAmdmt,
phi.formula = ~ DayAmdmt,
data = soil_phylum_small_otu1)

mod2 <- bbdml(formula = cbind(W, M - W) ~ 1,
phi.formula = ~ 1,
data = soil_phylum_small_otu1)
raotest(mod1, mod2)
}
