% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_individual_traits.R
\name{set_individual_traits}
\alias{set_individual_traits}
\title{Set, create or modify columns with information of individual organisms}
\usage{
set_individual_traits(
  .df,
  individualID = NULL,
  lifeStage = NULL,
  sex = NULL,
  vitality = NULL,
  reproductiveCondition = NULL,
  .keep = "unused"
)
}
\arguments{
\item{.df}{A \code{data.frame} or \code{tibble} that the column should be appended to.}

\item{individualID}{An identifier for an individual or named group of
individual organisms represented in the Occurrence. Meant to accommodate
resampling of the same individual or group for monitoring purposes. May
be a global unique identifier or an identifier specific to a data set.}

\item{lifeStage}{The age class or life stage of an organism at the time of
occurrence.}

\item{sex}{The sex of the biological individual.}

\item{vitality}{An indication of whether an organism was alive or dead at
the time of collection or observation.}

\item{reproductiveCondition}{The reproductive condition of the biological
individual.}

\item{.keep}{Control which columns from .data are retained in the output.
Note that unlike \code{\link[dplyr:mutate]{dplyr::mutate()}}, which defaults to \code{"all"} this defaults to
\code{"unused"}; i.e. only keeps Darwin Core columns, and not those columns used to
generate them.}
}
\value{
A \code{tibble} with the requested fields added/reformatted.
}
\description{
Format fields that contain measurements or attributes of individual
organisms to a \code{tibble} using Darwin Core Standard. Fields include those
that specify sex, life stage or condition. Individuals can be identified by
an \code{individualID} if data contains resampling.

In practice this is no different from using \code{mutate()}, but gives some
informative errors, and serves as a useful lookup for fields in
the Darwin Core Standard.
}
\details{
Examples of \code{lifeStage} values:
\itemize{
\item \code{zygote}
\item \code{larva}
\item \code{adult}
\item \code{seedling}
\item \code{flowering}
}

Examples of \code{vitality} values:
\itemize{
\item \code{alive}
\item \code{dead}
\item \code{uncertain}
}

Examples of \code{reproductiveCondition} values:
\itemize{
\item \code{non-reproductive}
\item \code{pregnant}
\item \verb{in bloom}
\item \verb{fruit bearing}
}
}
\examples{
df <- tibble::tibble(
  name = c("Crinia Signifera", "Crinia Signifera", "Litoria peronii"),
  latitude = c(-35.27, -35.24, -35.83),
  longitude = c(149.33, 149.34, 149.34),
  eventDate = c("2010-10-14", "2010-10-14", "2010-10-14"),
  id = c(4421, 4422, 3311),
  life_stage = c("juvenile", "adult", "adult")
  )

# Reformat columns to Darwin Core Standard
df |>
  set_individual_traits(
    individualID = id,
    lifeStage = life_stage
    )

}
\seealso{
\code{\link[=set_scientific_name]{set_scientific_name()}} for adding \code{scientificName} and authorship information.
}
