% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pid.R
\name{pid}
\alias{pid}
\title{Proportional-Integral-Derivative (PID) Controller}
\usage{
pid(p, i, d)
}
\arguments{
\item{p}{Proportional gain. A real and finite value.}

\item{i}{Integral gain. A real and finite value. set this to zero for PD and P-control}

\item{d}{Derivative gain. A real and finite value. set this to zero for PI and P-control}
}
\value{
Returns a transfer function model for the PID, PI, PD or P-controller.
}
\description{
\code{pid} Parallel form of the model of a PID controller
}
\details{
\code{pid} creates the transfer function model for a PID, PI, PD, and P-controller.
}
\examples{
C <- pid(350,300,50) # PID-control
P <- TF(" 1/(s^2 + 10* s + 20)")
T <- feedback(TF("C*P"), 1)
stepplot(T, seq(0,2,0.01))

C <- pid(300,0,0) # P-control
T <- feedback(TF("C*P"), 1)
stepplot(T, seq(0,2,0.01))

C <- pid(30,70,0) # PI-control
T <- feedback(TF("C*P"), 1)
stepplot(T, seq(0,2,0.01))

C <- pid(300,0,10) # PD-control
T <- feedback(TF("C*P"), 1)
stepplot(T, seq(0,2,0.01))

}
