% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald_CI_ratio_paired_2x2.R
\name{Wald_CI_ratio_paired_2x2}
\alias{Wald_CI_ratio_paired_2x2}
\title{The Wald confidence interval for the ratio of paired probabilities}
\usage{
Wald_CI_ratio_paired_2x2(n, alpha = 0.05)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Wald confidence interval for the ratio of paired
probabilities

Described in Chapter 8 "The Paired 2x2 Table"
}
\section{Table orientation}{
 In most study designs, rows designate a grouping of the data, for
instance, into treatment or exposure groups, while the columns indicate a
dichotomous outcome, usually with the first column representing the outcome
of interest. This designation of rows and columns may not be relevant in all
study designs, please see the introduction to chapter 8 for details.
}

\examples{
# Airway hyper-responsiveness before and after stem cell transplantation
# (Bentur et al., 2009)
Wald_CI_ratio_paired_2x2(bentur_2009)

# Complete response before and after consolidation therapy
# (Cavo et al., 2012)
Wald_CI_ratio_paired_2x2(cavo_2012)

}
