% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_selection.R
\name{map_selection}
\alias{map_selection}
\title{Map Selected Methods to Context}
\usage{
map_selection(x, num = 3, type = "both")
}
\arguments{
\item{x}{data.frame. As produced by \code{\link{find_method}}.}

\item{num}{numerical. The number of top ranking methods to highlight.}

\item{type}{character. The type of plot, either \dQuote{mca} for the results of
a multiple correspondence analyses of the trait space,
\dQuote{citation} for the citation network, or \dQuote{both} for both.}
}
\value{
a plot highlighting the position of the best fitting methods
in the context of all conservation prioritization methods included in the package.
Includes two subplots
\enumerate{
\item a multidimensional trait space resulting from a multiple correspondence analysis,
\item a citation network linking different methods by shred scientific publications.
}
}
\description{
Maps methods selected with \code{\link{find_method}} to the trait space
and/or citation network of methods included in conserveR,
to identify further similar methods.
}
\examples{
data(edge)
map_selection(edge)

}
