% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_proportion.R
\name{ci_proportion}
\alias{ci_proportion}
\title{CI for a Population Proportion}
\usage{
ci_proportion(
  x,
  n = NULL,
  probs = c(0.025, 0.975),
  type = c("Clopper-Pearson", "Agresti-Coull", "Wilson", "bootstrap"),
  boot_type = c("bca", "perc", "stud", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector with one value (0/1) per observation, or the number
of successes.}

\item{n}{The sample size. Only needed if \code{x} is a vector of length 1.}

\item{probs}{Lower and upper probabilities, by default \code{c(0.025, 0.975)}.}

\item{type}{Type of CI. One of "Clopper-Pearson" (the default), "Agresti–Coull",
"Wilson", "bootstrap".}

\item{boot_type}{Type of bootstrap CI. Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{\link[boot:boot]{boot::boot()}}.}
}
\value{
An object of class "cint", see \code{\link[=ci_mean]{ci_mean()}} for details.
}
\description{
This function calculates CIs for a population proportion. By default,
"Clopper-Pearson" CIs are calculated (via \code{\link[stats:binom.test]{stats::binom.test()}}).
Further possibilities are "Wilson" (without continuity correction),
"Agresti-Coull" (using normal quantile instead of +2 correction),
and "bootstrap" (by default "bca").
}
\details{
Note that we use the formulas for the Wilson and Agresti-Coull intervals in
\url{https://en.wikipedia.org/wiki/Binomial_proportion_confidence_interval}.
They agree with \code{binom::binom.confint(x, n, method = "ac"/"wilson")}.
}
\examples{
x <- rep(0:1, times = c(50, 100))
ci_proportion(x)
ci_proportion(x, type = "Wilson")
ci_proportion(x, type = "Agresti-Coull")
}
\references{
\enumerate{
\item Clopper, C. and Pearson, E. S. (1934). The use of confidence or fiducial limits
illustrated in the case of the binomial. Biometrika. 26 (4).
\item Wilson, E. B. (1927). Probable inference, the law of succession, and statistical
inference. Journal of the American Statistical Association, 22 (158).
\item Agresti, A. and Coull, B. A. (1998). Approximate is better than 'exact' for
interval estimation of binomial proportions. The American Statistician, 52 (2).
}
}
