% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa_mat.R
\name{cpa_scores}
\alias{cpa_scores}
\title{Compute CPA level and pattern scores for a set of data}
\usage{
cpa_scores(
  cpa_mod,
  newdata = NULL,
  augment = TRUE,
  cpa_names = c("cpa_lev", "cpa_pat"),
  scale = FALSE,
  scale_center = TRUE,
  scale_scale = TRUE
)
}
\arguments{
\item{cpa_mod}{A model returned from \code{\link[=cpa_mat]{cpa_mat()}} (a model of class \code{"cpa"})}

\item{newdata}{A data frame or matrix containing columns with the same names as
the predictors in \code{cpa_mod}.}

\item{augment}{Should be CPA score columns be added to \code{newdata} (\code{TRUE}, default)
or returned alone (\code{FALSE})?}

\item{cpa_names}{Character vector of length 2 giving the variable names to assign
to the CPA score columns.}

\item{scale}{Logical. Should the variables in \code{newdata} be scaled (standardized)?}

\item{scale_center}{If \code{scale} is \code{TRUE}, passed to the \code{center} argument in
\code{\link[base:scale]{base::scale()}}. Can be \code{TRUE} (center columns of \code{newdata} around the column
means), \code{FALSE} (don't center), or a numeric vector of length equal to the
number of predictors in \code{cpa_mod} containing the values to center around.}

\item{scale_scale}{If \code{scale} is \code{TRUE}, passed to the \code{scale} argument in
\code{\link[base:scale]{base::scale()}}. Can be \code{TRUE} (scale/standardize columns of \code{newdata} using
the column standard deviations or root mean squares), \code{FALSE} (don't scale),
or a numeric vector of length equal to the number of predictors in \code{cpa_mod}
containing the values to scale by. See \code{\link[base:scale]{base::scale()}} for details.}
}
\value{
A data frame containing the CPA score variables.
}
\description{
Compute CPA level and pattern scores for a set of data
}
\examples{
sevar <- cor_covariance_meta(mindfulness$r, mindfulness$n, mindfulness$sevar_r, mindfulness$source)
cpa_mod <- cpa_mat(mindfulness ~ ES + A + C + Ex + O,
                   cov_mat = mindfulness$r,
                   n = NULL,
                   se_var_mat = sevar,
                   adjust = "pop")

newdata <- data.frame(ES = c(4.2, 3.2, 3.4, 4.2, 3.8, 4.0, 5.6, 2.8, 3.4, 2.8),
                      A  = c(4.0, 4.2, 3.8, 4.6, 4.0, 4.6, 4.6, 2.6, 3.6, 5.4),
                      C  = c(2.8, 4.0, 4.0, 3.0, 4.4, 5.6, 4.4, 3.4, 4.0, 5.6),
                      Ex = c(3.8, 5.0, 4.2, 3.6, 4.8, 5.6, 4.2, 2.4, 3.4, 4.8),
                      O  = c(3.0, 4.0, 4.8, 3.2, 3.6, 5.0, 5.4, 4.2, 5.0, 5.2)
                      )

newdata_cpa <- cpa_scores(cpa_mod, newdata, augment = FALSE)
newdata_augment <- cpa_scores(cpa_mod, newdata, augment = TRUE)
}
