% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConditionKeeper.R
\docType{data}
\name{ConditionKeeper}
\alias{ConditionKeeper}
\title{ConditionKeeper}
\arguments{
\item{times}{(integer) number of times to throw condition. required.
default: 1}

\item{condition}{(character) which condition, one of "message" (default) or
"warning"}
}
\description{
ConditionKeeper
}
\details{
\strong{Methods}
\itemize{
\item \code{add(x)} - add a condition to internal storage
\item \code{remove()} - remove the first condition from internal storage; returns that
condition so you know what you removed
\item \code{purge()} - removes all conditions
\item \code{thrown_already(x)} - (return: logical) has the condition been thrown
already?
\item \code{not_thrown_yet(x)} - (return: logical) has the condition NOT been thrown
yet?
\item \code{thrown_times(x)} - (return: numeric) number of times the condition
has been thrown
\item \code{thrown_enough(x)} - (return: logical) has the condition been thrown
enough? "enough" being: thrown number of times equal to what you
specified in the \code{times} parameter
\item \code{get_id()} - get the internal ID for the ConditionKeeper object
\item \code{handle_conditions(expr)} - pass a code block or function and handle
conditions within it
}
}
\examples{
x <- ConditionKeeper$new(times = 4)
x
x$get_id()
x$add("one")
x$add("two")
x
x$thrown_already("one")
x$thrown_already("bears")
x$not_thrown_yet("bears")

x$add("two")
x$add("two")
x$add("two")
x$thrown_times("two")
x$thrown_enough("two")
x$thrown_enough("one")

foo <- function(x) {
  message("you gave: ", x)
  return(x)
}
foo('a')
x$handle_conditions(foo('a'))

x <- ConditionKeeper$new(times = 4, condition = "warning")
x
x$add("one")
x$add("two")
x
}
\seealso{
\code{\link[=handle_conditions]{handle_conditions()}}
}
\keyword{datasets}
