% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp.R
\name{concstats_sten}
\alias{concstats_sten}
\title{Stenbacka Index}
\usage{
concstats_sten(x, na.rm = TRUE)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{na.rm}{A logical vector that indicates whether \code{NA} values should
be excluded or not. Must be either \code{TRUE} or \code{FALSE}. The default
is \code{TRUE}.
If set to \code{FALSE} the computation yields \code{NA} if \code{NA} values
are present.}
}
\value{
A single numeric measure in decimal form.
}
\description{
Stenbacka Index
}
\details{
\code{concstats_sten} calculates the Stenbacka index,
which indicates the market share of a dominant position.
}
\examples{
# a vector of market shares
x <- c(0.35, 0.4, 0.05, 0.1, 0.06, 0.04)
concstats_sten(x)
# a vector with NA values
x <- c(0.4, 0.2, 0.25, 0.1, 0.05, NA)
concstats_sten(x, na.rm = FALSE)
}
\references{
Melnik, A., Shy, Oz, Stenbacka, R., (2008), "Assessing market
dominance", \emph{Journal of Economic Behavior and Organization},
68: pp. 63-72.
}
