% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov.R
\name{stoch-modifiers}
\alias{stoch-modifiers}
\alias{teleport}
\alias{vote_equal}
\alias{vote_self}
\title{Stochastic matrix modifiers}
\usage{
teleport(teleport_prob = 0.15)

vote_equal(stoch)

vote_self(stoch)
}
\arguments{
\item{teleport_prob}{Probability of 'teleportation'.}

\item{stoch}{Input stochastic matrix.}
}
\value{
\code{teleport()} returns a modifier function.

\code{vote_equal()} and \code{vote_self()} are modifier functions and return modified
version of input stochastic matrix.
}
\description{
Functions for stochastic matrix modifications.
}
\details{
Modification logic behind \code{teleport()} assumes that at each step
of Markov chain (described by column-stochastic matrix) the decision is made
whether to change state according to stochastic matrix or to 'teleport' to
any state with equal probability. Probability of 'teleport' is
\code{teleport_prob}. This modification is useful because it ensures
irreducibility of stochastic matrix (with \code{teleport_prob} in (0; 1)).
\strong{Note} that in order to obtain modifier one should call function
\code{teleport()} with some parameter.

\code{vote_equal()} and \code{vote_self()} modify columns with elements only equal to
0. The former fills them with \code{1/nrow(stoch)} and the latter changes only the
respective diagonal element to 1. This is equivalent to jump to any state
with equal probability and to stay in the current state respectively.
}
\examples{
input_stoch <- matrix(c(0, 0.3,
                        0, 0.7),
                      ncol = 2, byrow = TRUE)
teleport(0.15)(input_stoch)

vote_equal(input_stoch)

vote_self(input_stoch)

}
