% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcIso7933.R
\name{calcIso7933}
\alias{calcIso7933}
\title{Heat Strain Indices based on ISO 7933}
\usage{
calcIso7933(accl, posture, Ta, Pa, Tr, Va, Met, Icl, THETA, Walksp, Duration,
weight, height, DRINK, Adu, spHeat, SWp, Tre, Tcr, Tsk, Tcreq, Work, imst, 
Ap, Fr, defspeed, defdir, HR, pb)
}
\arguments{
\item{accl}{a numeric value presenting state of acclimation [100 if acclimatised subject, 0 otherwise]}

\item{posture}{a numeric value presenting posture of person [sitting=1, standing=2, crouching=3]}

\item{Ta}{a numeric value presenting air temperature in [degrees celsius]}

\item{Pa}{a numeric value presenting partial water vapour pressure [kPa]}

\item{Tr}{a numeric value presenting mean radiant temperature in [degrees celsius]}

\item{Va}{a numeric value presenting air velocity in [m/s]}

\item{Met}{a numeric value presenting metabolic rate in [W/(m*m)]}

\item{Icl}{a numeric value presenting static thermal insulation of clothing [clo]}

\item{THETA}{a numeric value presenting angle between walking direction and wind direction in [degrees]}

\item{Walksp}{a numeric value presenting walking speed in [m/s]}

\item{Duration}{a numeric value presenting the duration of the work sequence in [min]}

\item{weight}{a numeric value presenting the body mass in [kg]}

\item{height}{a numeric value presenting the body height in [m]}

\item{DRINK}{a numeric value presenting if workers can drink as they want [1 if they can drink without restriction, 0 if restricted]}

\item{Adu}{a numeric value presenting body surface area according to Du Bois [m*m]}

\item{spHeat}{a numeric value presenting specific body heat [(W/(m*m))/K]}

\item{SWp}{a numeric value presenting predicted sweat rate [W/(m*m)]}

\item{Tre}{a numeric value presenting rectal temperature [degrees celsius]}

\item{Tcr}{a numeric value presenting temperature of body core [degrees celsius]}

\item{Tsk}{a numeric value presenting skin temperature at start [degrees celsius]}

\item{Tcreq}{a numeric value presenting temperature of body core dependent on energy metabolism [degrees celsius]}

\item{Work}{a numeric value presenting effective mechanical power [W/(m*m)]}

\item{imst}{a numeric value presenting static moisture permeability index [-]}

\item{Ap}{a numeric value presenting fraction of the body surface covered by the reflective clothing [-]}

\item{Fr}{a numeric value presenting emissivity of the reflective clothing [-]}

\item{defspeed}{a numeric value presenting if walking speed entered [1 if walking speed entered, 0 otherwise]}

\item{defdir}{a numeric value presenting if walking direction entered [1 if walking direction entered, 0 otherwise]}

\item{HR}{a numeric value presenting humidity ratio [g/kg]}

\item{pb}{a numeric value presenting normal barometric pressure in [Pa]}
}
\value{
\code{calcISO7933} returns a data.frame with the following items: \cr
 \cr
 \code{Tre	final} rectal temperature [degrees Celsius] \cr
 \cr
 \code{SWtotg} total water loss [g]\cr
 \cr
 \code{Dlimtre} time when limit for rectal temperature is reached [min]\cr
 \cr
 \code{Dlimloss50} time when limit for water loss Dmax50 (7.5 percent of 
 body mass of an average person) is reached [min]\cr
 \cr
 \code{Dlimloss95} time when limit for water loss Dmax95 (5 percent of body 
 mass of 95 percent of the working people) is reached [min]\cr
 \cr
 \code{Cres} convective heat flow at respiration [W/(m*m)]\cr
 \cr
 \code{Eres} evaporative heat flow at respiration [W/(m*m)]\cr
 \cr
 \code{Ep} predicted evaporative heat flow [W/(m*m)]\cr
 \cr
 \code{SWp} predicted sweating rate [W/(m*m)]\cr
 \cr
 \code{Texp} temperature of the exhaled air [degrees Celsius]\cr
 \cr
 \code{Tskeq} skin Temperature in equilibrium [degrees Celsius]\cr
 \cr
 \code{Tsk} skin Temperature at the minute [degrees Celsius]\cr
 \cr
 \code{wp} predicted skin wettedness [-]\cr
}
\description{
\code{calcISO7933} calculates Tre, SWtotg, Dlimtre, Dlimloss50 and Dlimloss95 based 
on ISO 7933. It additionally provides intermediate results from the 
calculation: Cres, Eres, Ep, SWp, Texp, Tskeq, Tsk, wp
}
\details{
All variables must have the same length 1.
}
\note{
In case one of the variables is not given, a standard value according
to ISO 7933 will be taken.
}
\examples{
## Calculation of a single set of values.
calcIso7933(accl = 100, posture = 2, Ta = 35, Pa = 4, Tr = 35, Va = 0.3, Met = 150, 
Icl = 0.5, THETA = 0, Walksp = 0, Duration = 480)
calcIso7933(100,2,35,4,35,0.3,150,0.5,0,0,480)
## Using several rows of data:
accl <- 100
posture <- 2
Ta <- c(40,35)
Pa <- c(2.5,4)
Tr <- c(40,35)
Va <- 0.3
Met <- 150
Icl <- 0.5
THETA <- 0
Walksp <- 0
Duration <- 480
maxLength <- max(sapply(list(accl, posture, Ta, Pa, Tr, Va, Met, Icl, THETA,
Walksp, Duration), length))
PHI <- sapply(seq(maxLength), function(x) {calcIso7933(accl, posture, Ta[x], 
Pa[x], Tr[x], Va, Met, Icl, THETA, Walksp, Duration) } ) 
}
\references{
ISO 7933 (2004) Ergonomics of the thermal environment - Analytical determination and 
interpretation of heat stress using calculation of the predicted heat strain 
Malchaire, Piette, Kampmann, Mehnert, Gebhardt, Havenith, Den Hartog, Holmer, Parsons, Alfano, Griefahn (2000) <doi:10.1016/S0003-4878(00)00030-2>
Malchaire, Kampmann, Havenith, Mehnert, Gebhardt (2000) <doi:10.1007/s004200050420>
}
\author{
The code for calcISO7933 is based on the code in BASIC presented in 
Addendum E of EN ISO 7933. The translation into R-language conducted by Michael Kleber.
}
