% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_diversity.R
\name{community_diversity}
\alias{community_diversity}
\title{Community Diversity}
\usage{
community_diversity(
  df,
  time.var = NULL,
  abundance.var,
  replicate.var = NULL,
  metric = c("Shannon", "InverseSimpson")
)
}
\arguments{
\item{df}{A data frame containing species and abundance columns and optional
columns of time and/or replicate.}

\item{time.var}{The name of the optional time column}

\item{abundance.var}{The name of the abundance column}

\item{replicate.var}{The name of the optional replicate column. If specified,
replicate must be unique within the dataset and cannot be nested within
treatments or blocks.}

\item{metric}{The diversity measure to return:
\itemize{
 \item{"Shannon": }{The default measure, calculates Shannon's diversity.}
 \item{"InverseSimpson": }{Calculates inverse of Simpson's diversity.}
}}
}
\value{
The community_diversity function returns a data frame with the
  following attributes:
\itemize{
 \item{time.var: }{A column that has the same name and type as the time.var
 column, if time.var is specified.}
 \item{replicate.var: }{A column that has same name and type as the
 replicate.var column, if replicate.var is specified.}
 \item{Shannon: }{A numeric column of Shannon's diversity if metric =
 "Shannon"}
 \item{InverseSimpson: }{A numeric column of the inverse of Simpson's
 diversity if metric = "InverseSimpson"}
}
}
\description{
Calculates Shannon's or Inverse Simpson's diversity of a
  community, but only one measure of diversity can be calculated at a time and
  must be specified.
}
\examples{
data(pplots)
#Example with both time and replicates
df <- subset(pplots, plot == 25 | plot == 6)
community_diversity(df,
                    time.var="year", 
                    replicate.var = "plot", 
                    abundance.var = "relative_cover") # for Shannon's diversity measure

df <- subset(pplots, plot == 25 | plot == 6)
community_diversity(df, 
                    time.var="year", 
                    replicate.var = "plot", 
                    abundance.var = "relative_cover", 
                    metric = "InverseSimpson") # for Inverse of Simpson's diversity measure

#Example with no replicates
df <- subset(pplots, plot == 25)
community_diversity(df,
                    time.var="year", 
                    abundance.var = "relative_cover") # for Shannon's diversity measure
                    
#Example with no time or replicate
df <- subset(pplots, plot == 25 & year == 2002)
community_diversity(df,
                    abundance.var = "relative_cover") # for Shannon's diversity measure
}
\references{
Magurran, A.E. 2004. Measuring Biological Diversity. Blackwell
  Publishing, Malden MA, USA.
}
