% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl_filter.R
\name{cl_filter}
\alias{cl_filter}
\title{Filter a code list}
\usage{
cl_filter(codelist, locale, levels, check_levels = TRUE)
}
\arguments{
\item{codelist}{a \code{\link{codelist}} object.}

\item{locale}{use the codes from the given locale. Should be character
vector of length 1. When NA the default locale is used (as returned by
\code{\link{cl_locale}}.}

\item{levels}{vector with levels on which to filter an hierarchical code list.
Levels are numbered from 0 with 0 the topmost level. See 'Details'. When a
code list does not have a 'parent' column and is, therefore, not hierarchical
all codes are in level 0.}

\item{check_levels}{if TRUE the parent column (if present) is removed from
the result when the resulting code list would not be a valid hierarchy.}
}
\value{
Returns a \code{\link{codelist}} with the selected encoding and/or levels.
}
\description{
Filter a code list
}
\details{
When a code list has a 'parent' column. The codes without parent are assigned
level 0. Codes with a parent in level 0 are assigned to level 1. Etc. When
the code list does not have a 'parent' column all codes are assigned to level
0 (all codes are in the top level).
}
