% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{clustra_rand}
\alias{clustra_rand}
\title{clustra_rand: Rand Index cluster evaluation}
\usage{
clustra_rand(
  data,
  k,
  starts = "random",
  mccores = 1,
  replicates = 10,
  maxdf = 30,
  conv = c(10, 0),
  save = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{The data (see \code{\link{clustra}} description).}

\item{k}{Vector of k values to try.}

\item{starts}{See \code{\link{clustra}}.}

\item{mccores}{Number of cores for replicate parallelism via mclapply.}

\item{replicates}{Number of replicates for each k.}

\item{maxdf}{Fitting parameters. See \code{link{trajectories}}.}

\item{conv}{Fitting parameters. See \code{link{trajectories}}.}

\item{save}{Logical. When TRUE, save all results as file \code{results.Rdata}.}

\item{verbose}{Logical. When TRUE, information about each run of clustra (but not iterations
within) is printed.}
}
\value{
See \code{\link{allpair_RandIndex}}.
}
\description{
Performs \code{\link{trajectories}} runs for several \emph{k} and several random
start replicates within \emph{k}. Returns a data frame with a Rand Index
comparison between all pairs of clusterings. This data frame is typically
input to \code{\link{rand_plot}} to produce a heat map with the Adjusted
Rand Index results.
}
