% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractTree.R
\name{taxonomyGet}
\alias{taxonomyGet}
\title{Load a bird taxonomy into the R environment}
\usage{
taxonomyGet(taxonomy_year, data_path = FALSE)
}
\arguments{
\item{taxonomy_year}{The eBird taxonomy year the tree should be output in. Current options
are 2021-2024. Both numeric and character inputs are acceptable here. Any value
aside from these years will result in an error. Default is most recent year.}

\item{data_path}{Default to FALSE. If a summary, dated tree is desired, this is sufficient
and does not need to be modified. However, if a user wishes to extract a set of complete
dated trees, for example to iterate an analysis across a cloud of trees, or to use an
older version of the tree than the current one packed in the data object, this function
can also accept a path to the downloaded set of trees. If you have already downloaded the AvesData repo
available at https://github.com/McTavishLab/AvesData use data_path= the path to the download location.
Alternately, you can download the full data repo using \code{\link[=get_avesdata_repo]{get_avesdata_repo()}}. This approach will download the data and
set an environmental variable AVESDATA_PATH. When AVESDATA_PATH is set, the data_path will default to this value.
To manually set AVESDATA_PATH to the location of your downloaded AvesData repo use \code{\link[=set_avesdata_repo_path]{set_avesdata_repo_path()}}}
}
\value{
A \code{data.frame} with 17 columns of taxonomic information: order, species code, taxon concept, common name, scientific name, family, OpenTree Taxonomy data, etc.
}
\description{
\code{taxonomyGet} either reads a taxonomy file and loads it
as a \verb{data frame}, or loads the default taxonomy data object.
}
\details{
This will return a data object that has the taxonomy of the requested year.
}
