% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock-labels.R
\name{clock_labels}
\alias{clock_labels}
\alias{clock_labels_lookup}
\alias{clock_labels_languages}
\title{Create or retrieve date related labels}
\usage{
clock_labels(
  month,
  month_abbrev = month,
  weekday,
  weekday_abbrev = weekday,
  am_pm
)

clock_labels_lookup(language)

clock_labels_languages()
}
\arguments{
\item{month, month_abbrev}{\verb{[character(12)]}

Full and abbreviated month names. Starts with January.}

\item{weekday, weekday_abbrev}{\verb{[character(7)]}

Full and abbreviated weekday names. Starts with Sunday.}

\item{am_pm}{\verb{[character(2)]}

Names used for AM and PM.}

\item{language}{\verb{[character(1)]}

A BCP 47 locale, generally constructed from a two or three
digit language code. See \code{clock_labels_languages()} for a complete list of
available locales.}
}
\value{
A \code{"clock_labels"} object.
}
\description{
When parsing and formatting dates, you often need to know how weekdays of
the week and months are represented as text. These functions allow you
to either create your own labels, or look them up from a standard set of
language specific labels. The standard list is derived from ICU
(\url{https://unicode-org.github.io/icu/}) via the stringi package.
\itemize{
\item \code{clock_labels_lookup()} looks up a set of labels from a
given language code.
\item \code{clock_labels_languages()} lists the language codes that are accepted.
\item \code{clock_labels()} lets you create your own set of labels. Use this if the
currently supported languages don't meet your needs.
}
}
\examples{
clock_labels_lookup("en")
clock_labels_lookup("ko")
clock_labels_lookup("fr")
}
