% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clmplusAggregateDataPP.R
\name{clmplus}
\alias{clmplus}
\title{Fit Chain Ladder plus on Run-off Triangles.}
\usage{
clmplus(
  AggregateDataPP,
  hazard.model = NULL,
  link = c("log", "logit"),
  staticAgeFun = TRUE,
  periodAgeFun = "NP",
  cohortAgeFun = NULL,
  effect_log_scale = TRUE,
  constFun = function(ax, bx, kt, b0x, gc, wxt, ages) list(ax = ax, bx = bx, kt = kt, b0x
    = b0x, gc = gc),
  ...
)
}
\arguments{
\item{AggregateDataPP}{\code{AggregateDataPP} object, reverse time triangle to be fitted.}

\item{hazard.model}{\code{character}, hazard model supported from our package. The model can be chosen from:
\itemize{
\item{'a': Age model, this is equivalent to the Mack chain-ladder.}
\item{'ac': Age and cohort effects.}
\item{'ap': Age and cohort effects.}
\item{'apc': Age cohort and period effects.}
}}

\item{link}{\code{character}, defines the link function and random component associated with 
the mortality model. \code{"log"} would assume that deaths follow a 
Poisson distribution and use a log link while \code{"logit"} would assume 
that deaths follow a Binomial distribution and a logit link.
To be disregarded unless the practitioner specifies his own hazard model in StMoMo.}

\item{staticAgeFun}{\code{logical}, indicates if a static age function 
\eqn{\alpha_x} is to be included. To be disregarded unless the practitioner specifies his own hazard model in StMoMo.}

\item{periodAgeFun}{\code{list}, a list of length \eqn{N} with the definitions of the 
period age modulating parameters \eqn{\beta_x^{(i)}}. Each entry can take 
values: \code{"NP"} for non-parametric age terms, \code{"1"} for 
\eqn{\beta_x^{(i)}=1} or a predefined parametric function of 
age (see details). Set this to \code{NULL} if there are no period terms 
in the model.
To be disregarded unless the practitioner specifies his own hazard model in StMoMo.}

\item{cohortAgeFun}{\code{character} or \code{function}, defines the cohort age modulating parameter 
\eqn{\beta_x^{(0)}}. It can take values: \code{"NP"} for non-parametric 
age terms, \code{"1"} for \eqn{\beta_x^{(0)}=1}, a predefined parametric 
function of age (see details) or \code{NULL} if there is no cohort effect. 
To be disregarded unless the practitioner specifies his own hazard model in StMoMo.}

\item{effect_log_scale}{\code{logical}, whether effects should be on the logarithmic scale. By default, \code{TRUE}.}

\item{constFun}{\code{function}, it defines the identifiability constraints of the 
model. It must be a function of the form 
\code{constFun <- function(ax, bx, kt, b0x, gc, wxt, ages)} taking a set
of fitted model parameters and returning a list 
\code{list(ax = ax, bx = bx, kt = kt, b0x = b0x, gc = gc)}
of the model parameters with the identifiability constraints applied. If 
omitted no identifiability constraints are applied to the model.
To be disregarded unless the practitioner specifies his own hazard model in StMoMo.}

\item{...}{parameters to be passed to clmplus.}
}
\value{
No return value, called to pass method \code{clmplus.AggregateDataPP}. See \code{clmplus.AggregateDataPP} documentation.
}
\description{
Method to Estimate Chain Ladder plus models.
}
\examples{
data(sifa.mtpl)
sifa.mtpl.rtt <- AggregateDataPP(cumulative.payments.triangle=sifa.mtpl)
hz.chl=clmplus(sifa.mtpl.rtt, 'a')

}
\references{
Pittarello, Gabriele, Munir Hiabu, and Andrés M. Villegas. "Replicating and extending chain ladder 
via an age-period-cohort structure on the claim development in a run-off triangle." arXiv preprint arXiv:2301.03858 (2023).
}
