% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modelling.R
\name{calc.model}
\alias{calc.model}
\title{Modelling}
\usage{
calc.model(
  envrmt = .GlobalEnv$envrmt,
  method = "monthly",
  timespan,
  climresp,
  classifier = c("rf", "pls", "lm", "glm"),
  seed = NULL,
  p = 0.8,
  folds = "all",
  predrows,
  mnote = NULL,
  k = NULL,
  tc_method = "cv",
  metric = "RMSE",
  doParallel = FALSE,
  autocorrelation = FALSE,
  ...
)
}
\arguments{
\item{envrmt}{variable name of your envrmt list created using climodr's `envi.create` function. Default = envrmt.}

\item{method}{character. Time period of your desired model. Default: "monthly"}

\item{timespan}{numeric. Vector or single input. Should contain all years to
be modeled. The years have to be the same format as in the
tabular data.}

\item{climresp}{numeric. Vector or single input. Should contain all column's
in the tabular data that contain response variables.}

\item{classifier}{vector or character. Model variants to be used. Supported
models: Random Forest = "rf", Partial-Least-Squares = "pls",
Neural Networks = "nnet", Linear Regression = "lm" or
generalized boosted regression = "gbm".}

\item{seed}{integer. Seed to reproduce the same model over and over.}

\item{p}{numeric. Between 0 and 1. Percentage of data used for cross
validation. Default = 0.8}

\item{folds}{character. Vector or single input. Either folding over location
only "LLO", over time only "LTO", or over both "LLTO". Use
"all" to use all possibilitys.}

\item{predrows}{numeric. Vector or single input. Should contain the rows where
all the predictor values are stored in.}

\item{mnote}{character. Model note for special modifications used.
Default: "normal"}

\item{k}{integer. When 'fold' = "LLO" or "LTO". Set k to the number
of unique spatial or temporal units.  Leave out to use preset
values.}

\item{tc_method}{character. Method for train control function from caret
package. Default = "cv".}

\item{metric}{character. See `train`.}

\item{doParallel}{logical. Parallelization accelerates the modelling
process. Warning: Your PC will slow down drastically. Make
sure to not run any other heavy processes during this.}

\item{autocorrelation}{logical. Should autocorrelating data in the predictor
variables be excluded from the model run? Only works if
`autocorr` has been executed beforehand.}

\item{...}{arguments passed down from other functions.}
}
\value{
data frame.
}
\description{
Creates Models for each climate value
}
\examples{
\donttest{
#create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

# Load the climodr example data into the current climodr environment
clim.sample(envrmt = envrmt)

#prepare csv-files
prep.csv(envrmt = envrmt,
         method = "proc",
         save_output = TRUE)

#process csv-files
csv_data <- proc.csv(envrmt = envrmt,
                     method = "monthly",
                     rbind = TRUE,
                     save_output = TRUE)

# Crop all raster bands
crop.all(envrmt = envrmt,
         method = "MB_Timeseries",
         overwrite = TRUE)

# Calculate Indices from cropped raster bands
calc.indices(envrmt = envrmt,
             vi = "all",
             bands = c("blue", "green", "red",
                       "nir", "nirb",
                       "re1", "re2", "re3",
                       "swir1", "swir2"),
             overwrite = TRUE)

#extract station coordinates
csv_spat <- spat.csv(envrmt = envrmt,
                     method = "monthly",
                     des_file = "plot_description.csv",
                     save_output = TRUE)


#extract predictor values from raster files
csv_fin <- fin.csv(envrmt = envrmt,
                   method = "monthly",
                   save_output = TRUE)

# Test data for autocorrelation after running fin.csv
autocorr(envrmt = envrmt,
         method = "monthly",
         resp = 5,
         pred = c(8:23),
         plot.corrplot = FALSE)

# Create 36 different models (12 months x 3 classifiers) for every month in 2017
calc.model(envrmt = envrmt,
           method = "monthly",
           timespan = c(2017),
           climresp = 5,
           classifier = c("rf",
                          "pls",
                          "lm"),
           seed = 707,
           p = 0.8,
           folds = "LLO",
           mnote = "normal",
           predrows = c(8:23),
           tc_method = "cv",
           metric = "RMSE",
           autocorrelation = TRUE,
           doParallel = FALSE)
}
}
\seealso{
`autocorr`
}
