% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet-forecast-utils.R
\name{aemet_forecast_tidy}
\alias{aemet_forecast_tidy}
\alias{aemet_forecast_vars_available}
\title{Helper functions for extracting forecasts}
\usage{
aemet_forecast_tidy(x, var)

aemet_forecast_vars_available(x)
}
\arguments{
\item{x}{A database extracted with \code{\link[=aemet_forecast_daily]{aemet_forecast_daily()}} or
\code{\link[=aemet_forecast_hourly]{aemet_forecast_hourly()}}.}

\item{var}{Name of the desired var to extract}
}
\value{
A vector of characters (\code{\link[=aemet_forecast_vars_available]{aemet_forecast_vars_available()}})
or a \code{\link[tibble:tibble]{tibble}} (\code{\link[=aemet_forecast_tidy]{aemet_forecast_tidy()}}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Helpers for \code{\link[=aemet_forecast_daily]{aemet_forecast_daily()}}
and \code{\link[=aemet_forecast_hourly]{aemet_forecast_hourly()}}:
\itemize{
\item \code{\link[=aemet_forecast_vars_available]{aemet_forecast_vars_available()}} extracts the values available on
the dataset.
\item \code{\link[=aemet_forecast_tidy]{aemet_forecast_tidy()}} produces a \code{\link[tibble:tibble]{tibble}} with the
forecast for \code{var}.
}
}
\examples{
\dontshow{if (aemet_detect_api_key()) withAutoprint(\{ # examplesIf}
# Hourly values
hourly <- aemet_forecast_hourly(c("15030", "28079"))

# Vars available
aemet_forecast_vars_available(hourly)

# Get temperature
temp <- aemet_forecast_tidy(hourly, "temperatura")

library(dplyr)
# Make hour - Need lubridate to adjust timezones
temp_end <- temp |>
  mutate(
    forecast_time = lubridate::force_tz(
      as.POSIXct(fecha) + hora,
      tz = "Europe/Madrid"
    )
  )

# Add also sunset and sunrise
suns <- temp_end |>
  select(nombre, fecha, orto, ocaso) |>
  distinct_all() |>
  group_by(nombre) |>
  mutate(
    ocaso_end = lubridate::force_tz(
      as.POSIXct(fecha) + ocaso,
      tz = "Europe/Madrid"
    ),
    orto_end = lubridate::force_tz(
      as.POSIXct(fecha) + orto,
      tz = "Europe/Madrid"
    ),
    orto_lead = lead(orto_end)
  ) |>
  tidyr::drop_na()


# Plot

library(ggplot2)

ggplot(temp_end) +
  geom_rect(data = suns, aes(
    xmin = ocaso_end, xmax = orto_lead,
    ymin = min(temp_end$temperatura),
    ymax = max(temp_end$temperatura)
  ), alpha = .4) +
  geom_line(aes(forecast_time, temperatura), color = "blue4") +
  facet_wrap(~nombre, nrow = 2) +
  scale_x_datetime(labels = scales::label_date_short()) +
  scale_y_continuous(labels = scales::label_number(suffix = "º")) +
  labs(
    x = "", y = "",
    title = "Forecast: Temperature",
    subtitle = paste("Forecast produced on", format(temp_end$elaborado[1],
      usetz = TRUE
    ))
  )
\dontshow{\}) # examplesIf}
}
\seealso{
Other forecasts: 
\code{\link{aemet_forecast_beaches}()},
\code{\link{aemet_forecast_daily}()},
\code{\link{aemet_forecast_fires}()}
}
\concept{forecasts}
