% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_clusterings.R
\name{fowlkes_mallows}
\alias{fowlkes_mallows}
\title{Fowlkes-Mallows Index Between Clusterings}
\usage{
fowlkes_mallows(true, pred)
}
\arguments{
\item{true}{ground truth clustering represented as a membership
vector. Each entry corresponds to an element and the value identifies
the assigned cluster. The specific values of the cluster identifiers
are arbitrary.}

\item{pred}{predicted clustering represented as a membership
vector.}
}
\description{
Computes the Fowlkes-Mallows index between two clusterings,
such as a predicted and ground truth clustering.
}
\details{
The Fowlkes-Mallows index is defined as the geometric mean of
precision and recall, computed with respect to pairs of elements.
}
\examples{
true <- c(1,1,1,2,2)  # ground truth clustering
pred <- c(1,1,2,2,2)  # predicted clustering
fowlkes_mallows(true, pred)

}
\references{
Fowlkes, E. B. and Mallows, C. L. "A Method for Comparing Two Hierarchical
Clusterings." \emph{Journal of the American Statistical Association} \strong{78:383},
553-569, (1983). \doi{10.1080/01621459.1983.10478008}
}
