% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_pairs.R
\name{eval_report_pairs}
\alias{eval_report_pairs}
\title{Evaluation Report for Linked Pairs}
\usage{
eval_report_pairs(true_pairs, pred_pairs, num_pairs = NULL, ordered = FALSE)
}
\arguments{
\item{true_pairs}{set of true coreferent pairs stored in a matrix or
data.frame, where rows index pairs and columns index the ids of the
constituents. Any pairs not included are assumed to be \emph{non-coreferent}.
Duplicate pairs (including equivalent pairs with reversed ids) are
automatically removed.}

\item{pred_pairs}{set of predicted coreferent pairs, following the same
specification as \code{true_pairs}.}

\item{num_pairs}{the total number of coreferent and non-coreferent pairs,
excluding equivalent pairs with reversed ids. If not provided,
measures that depend on the number of true negatives will be returned
as \code{NA}.}

\item{ordered}{whether to treat the element pairs as ordered---i.e. whether
pair \eqn{(x, y)} is distinct from pair \eqn{(y, x)} for \eqn{x \neq y}.
Defaults to FALSE, which is appropriate for clustering, undirected link
prediction, record linkage etc.}
}
\value{
Returns a list containing the following measures:
\describe{
\item{precision}{see \code{\link{precision_pairs}}}
\item{recall}{see \code{\link{recall_pairs}}}
\item{specificity}{see \code{\link{specificity_pairs}}}
\item{sensitivity}{see \code{\link{sensitivity_pairs}}}
\item{f1score}{see \code{\link{f_measure_pairs}}}
\item{accuracy}{see \code{\link{accuracy_pairs}}}
\item{balanced_accuracy}{see \code{\link{balanced_accuracy_pairs}}}
\item{fowlkes_mallows}{see \code{\link{fowlkes_mallows_pairs}}}
}
}
\description{
Compute various evaluation measures for a set of \emph{predicted}
coreferent (linked) pairs given a set of \emph{ground truth} coreferent pairs.
}
\examples{
### Example where pairs/edges are undirected
# ground truth is 3-clique
true_pairs <- rbind(c(1,2), c(2,3), c(1,3))
# prediction misses one edge
pred_pairs <- rbind(c(1,2), c(2,3))
# total number of pairs assuming 3 elements
num_pairs <- 3 * (3 - 1) / 2
eval_report_pairs(true_pairs, pred_pairs, num_pairs)

### Example where pairs/edges are directed
# ground truth is a 3-star
true_pairs <- rbind(c(2,1), c(3,1), c(4,1))
# prediction gets direction of one edge incorrect
pred_pairs <- rbind(c(2,1), c(3,1), c(1,4))
# total number of pairs assuming 4 elements
num_pairs <- 4 * 4
eval_report_pairs(true_pairs, pred_pairs, num_pairs, ordered = TRUE)

}
\seealso{
The \code{\link{contingency_table_pairs}} function can be used to compute
the contingency table for entity resolution or record linkage problems.
}
