% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{predictions_list_schedules}
\alias{predictions_list_schedules}
\title{Show the prediction schedule}
\usage{
predictions_list_schedules(id)
}
\arguments{
\item{id}{integer required. ID of the prediction associated with this schedule.}
}
\value{
A list containing the following elements:
\item{id}{integer, ID of the prediction associated with this schedule.}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Days of the week, based on numeric value starting at 0 for Sunday. Mutually exclusive with scheduledDaysOfMonth
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Deprecated in favor of scheduled minutes.
\item scheduledDaysOfMonth array, Days of the month it is scheduled on, mutually exclusive with scheduledDays.
}}
\item{scoreOnModelBuild}{boolean, Whether the prediction will run after a rebuild of the associated model.}
}
\description{
Show the prediction schedule
}
