% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{ccGenomicRainfall}
\alias{ccGenomicRainfall}
\title{Create a rainfall plot}
\usage{
ccGenomicRainfall(
  data,
  mode = "min",
  ylim = NULL,
  col = "black",
  pch = par("pch"),
  cex = par("cex"),
  normalize_to_width = FALSE,
  ...
)
}
\arguments{
\item{data}{A bed-file-like data frame or a list of data frames.
}

\item{mode}{How to calculate the distance of two neighbouring regions, pass to \code{\link[circlize]{rainfallTransform}}.
}

\item{ylim}{ylim for rainfall plot track. If \code{normalize_to_width} is \code{FALSE}, the value should correspond to \code{log10(dist+1)},
 and if \code{normalize_to_width} is \code{TRUE}, the value should correspond to \code{log2(rel_dist)}.
}

\item{col}{Color of points. It should be length of one. If \code{data} is a list, the length of \code{col}
 can also be the length of the list.
}

\item{pch}{Style of points.
}

\item{cex}{Size of points.
}

\item{normalize_to_width}{If it is \code{TRUE}, the value is the relative distance divided by the width of the region.
}

\item{...}{Pass to \code{\link[circlize]{circos.trackPlotRegion}}.
}
}
\value{
Object \linkS4class{ccGenomicTrack}
}
\description{
Object \linkS4class{ccGenomicTrack} will call the function \link[circlize:circos.genomicRainfall]{circlize::circos.genomicRainfall} while drawing.
}
\examples{
\donttest{
library(circlizePlus)
load(system.file(package = "circlize", "extdata", "DMR.RData"))
cc = ccPlot(initMode="initializeWithIdeogram", chromosome.index = paste0("chr", 1:22))
bed_list = list(DMR_hyper, DMR_hypo)
t1 = ccGenomicRainfall(bed_list, pch = 16, cex = 0.4, col = c("#FF000080", "#0000FF80"))
cc + t1
circos.clear()
}
}
