% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chyper.R
\name{qchyper}
\alias{qchyper}
\title{Quantile function for conditional hypergeometric distributions}
\usage{
qchyper(p, s, n, m, verbose = T)
}
\arguments{
\item{p}{the desired quantile or quantiles}

\item{s}{an integer representing the size of the intersecting population}

\item{n}{a vector of integers representing the sizes of each non-intersecting population}

\item{m}{a vector of integers representing the sample sizes}

\item{verbose}{T/F should intermediate messages be printed?}
}
\value{
The minimum integer (or integers for a vector input) such that the input probability is less than or equal to the probability of sampling that many of the same items in all samples.
}
\description{
Calculates the quantile function of a conditional hypergeometric distribution: the distribution of how many items are in the overlap of all samples when samples of arbitrary size are each taken without replacement from populations of arbitrary size.
}
\examples{
qchyper(c(0,0.9,1), 10, c(12,13,14), c(7,8,9))

}
