% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edges_to_sf.R
\name{edges_to_sf}
\alias{edges_to_sf}
\title{Convert edge list to spatial object}
\usage{
edges_to_sf(edges, sites)
}
\arguments{
\item{edges}{a \code{data.frame} with the following two columns: \code{from} (the
first node of the edge) and \code{to} (the second node of the edge). The output
of the functions \code{\link[=create_edge_list]{create_edge_list()}} or \code{\link[=append_edge_lists]{append_edge_lists()}}.}

\item{sites}{an \code{sf} object of type \code{POINT}. A spatial object with
coordinates of sites (nodes). Note that the \strong{first column} must be the
node labels.}
}
\value{
An \code{sf} spatial object of type \code{LINESTRING} where the number of rows
correspond to the number of edges.
}
\description{
Converts an edge list to an \code{sf} spatial object of type \code{LINESTRING} with
one row per edge.
}
\examples{
# Import Adour sites ----
path_to_file <- system.file("extdata", "adour_survey_sampling.csv", 
                            package = "chessboard")
adour_sites  <- read.csv(path_to_file)

# Select first location ----
adour_sites <- adour_sites[adour_sites$"location" == 1, ]

# Create node labels ----
adour_nodes <- create_node_labels(data     = adour_sites, 
                                  location = "location", 
                                  transect = "transect", 
                                  quadrat = "quadrat")

# Find edges with 1 degree of neighborhood (pawn method) ----
adour_edges <- create_edge_list(adour_nodes, method = "pawn", 
                                directed = TRUE)

# Convert sites to spatial POINT ----
adour_sites_sf <- sf::st_as_sf(adour_nodes, coords = 5:6, crs = "epsg:2154")

# Convert edges to spatial LINESTRING ----
edges_sf <- edges_to_sf(adour_edges, adour_sites_sf)
head(edges_sf)

# Visualization ----
plot(sf::st_geometry(adour_sites_sf), pch = 19)
plot(sf::st_geometry(edges_sf), add = TRUE)


# Find edges with 1 degree of neighborhood (pawn and bishop methods) ----
adour_edges_1 <- create_edge_list(adour_nodes, method = "pawn", 
                                  directed = TRUE)
adour_edges_2 <- create_edge_list(adour_nodes, method = "bishop", 
                                  directed = TRUE)

# Append edges ----
adour_edges <- append_edge_lists(adour_edges_1, adour_edges_2)

# Convert sites to spatial POINT ----
adour_sites_sf <- sf::st_as_sf(adour_nodes, coords = 5:6, crs = "epsg:2154")

# Convert edges to spatial LINESTRING ----
edges_sf <- edges_to_sf(adour_edges, adour_sites_sf)
head(edges_sf)

# Visualization ----
plot(sf::st_geometry(adour_sites_sf), pch = 19)
plot(sf::st_geometry(edges_sf), add = TRUE)
}
