#' ChatGPT: Complete Code
#'
#' @param code The code to be completed by ChatGPT. If not provided, it will use what's copied on
#'   the clipboard.
#'
#' @examples
#' \dontrun{
#' cat(complete_code("# A function to square each element of a vector\nsquare_each <- function("))
#' }
#'
#' @importFrom clipr read_clip
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
complete_code <- function(code = clipr::read_clip(allow_non_interactive = TRUE)) {
  code <- paste(gsub('"', "'", code), collapse = "\n")
  prompt <- paste0('Complete the following R code: "', code, '"')
  parse_response(gpt_get_completions(prompt))
}
