% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_polynomial.R
\name{gen.piece.poly.noiseless}
\alias{gen.piece.poly.noiseless}
\title{Mean function of piecewise polynomials.}
\usage{
gen.piece.poly.noiseless(init_coef_vec, cpt_vec, kappa_mat, n)
}
\arguments{
\item{init_coef_vec}{A \code{numeric} vector of coefficients for the first segment.}

\item{cpt_vec}{An \code{integer} vector of change points.}

\item{kappa_mat}{A \code{numeric} matrix where the i-th column represents the jump sizes for coefficients associated with the i-th change point.}

\item{n}{An \code{integer} scalar of sample size.}
}
\value{
A vector of mean function of piecewise polynomials.
}
\description{
Compute mean function of piecewise polynomials (currently, only the linear, quadratic functions and cubic functions are considered).
}
\examples{
r = 2
init_coef_vec = c(-2, 2, 9)
cpt_true = c(100, 200)
n = 300
kappa_mat = cbind(c(3, 9, -27), c(-3, 9, -27))
plot.ts(gen.piece.poly.noiseless(init_coef_vec, cpt_true, kappa_mat, n), 
        ylab = "Values of piecewise polynomials")
}
\references{
Yu and Chatterjee (2020) <arXiv:2007.09910>
}
\author{
Haotian Xu
}
