% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_mean_robust.R
\name{ARC}
\alias{ARC}
\title{Adversarially robust univariate mean change point detection.}
\usage{
ARC(y, h, block_num = 1, epsilon, gaussian = TRUE)
}
\arguments{
\item{y}{A \code{numeric} vector of observations.}

\item{h}{An \code{integer} scalar representing block size.}

\item{block_num}{An \code{integer} scalar representing number of blocks used when searching for local maximiser.}

\item{epsilon}{A \code{numeric} scalar in (0,1) representing contamination proportion.}

\item{gaussian}{A \code{logical} scalar representing whether to treat the inlier distribution (F) as Gaussian distribution.}
}
\value{
An \code{numeric} vector of estimated change point locations
}
\description{
Perform the adversarially robust change point detection method.
}
\examples{
### simulate data with contamination
obs_num = 1000
D = 2
noise = 0.1 # proportion of contamination
mu0 = 0
mu1 = 1
sd =1
idmixture = rbinom(obs_num/D, 1, 1-noise)
dat = NULL
for (j in 1:D){
  for (i in 1:(obs_num/(2*D))){
    if (idmixture[i] == 1){
      dat = c(dat,rnorm(1,mu0,sd))
    }
    else{
      dat = c(dat,rnorm(1,mu1/(2*noise),0))
    }
  }
  for (i in (obs_num/(2*D)+1):(obs_num/D)){
    if (idmixture[i] == 1){
      dat = c(dat,rnorm(1,mu1,sd))
    }
    else{
      dat = c(dat,rnorm(1,mu1/(2*noise)-(1-noise)*mu1/noise,0))
    }
  }
}
plot(dat)
### perform ARC
ARC(dat,h = 120, epsilon = 0.1)
}
\references{
Li and Yu (2021) <arXiv:2105.10417>.
}
\author{
Mengchu Li
}
